/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.executor.busi;

import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.ConfigClassXml;
import net.wicp.tams.common.connector.executor.impl.AbsConfigManager;
import net.wicp.tams.common.exception.ProjectException;

/****
 * 由key决定调用的配置信息，这样就不需要service.properties文件了 appKey 为 a.b.c 将转为路径 a/b/c
 * 
 * @author zhoujunhui
 *
 */
@SuppressWarnings("rawtypes")
public class KeyConfigManager extends AbsConfigManager {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	private Class classz;

	private ClassLoader classLoader;

	public KeyConfigManager(String dir) {
		super(dir);
	}

	public KeyConfigManager() {
		super();
	}

	public KeyConfigManager(Class classz) {
		this.classz = classz;
	}

	public KeyConfigManager(ClassLoader classLoader) {
		this.classLoader = classLoader;
	}

	public synchronized void refresh(ClassLoader classLoader) {
		super.refresh();
		this.classLoader = classLoader;
	}

	@Override
	protected AbstractConfigClass createConfig(String appKey) {
		String xmlValue = appKey.replaceAll("\\.", "/") + ".xml";
		try {
			String path = StringUtil.isNull(dir) ? xmlValue : IOUtil.mergeFolderAndFilePath(dir, xmlValue);

			InputStream inputStream = null;
			if (classLoader != null) {
				inputStream = classLoader.getResourceAsStream(path);
			} else {
				inputStream = IOUtil.fileToInputStream(path, classz);
			}
			if (inputStream == null) {
				inputStream = ClassPathXml.getXmlStream(appKey);
			}
			AbstractConfigClass retobj = ConfigClassXml.createConfigClassXml(appKey, inputStream);
			return retobj;
		} catch (ProjectException e) {
			logger.error("------加载" + appKey + "对应的xml错误------", e);
			throw new IllegalArgumentException("------加载" + appKey + "对应的xml错误------");
		}
	}

}
