/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.executor;

import com.fasterxml.jackson.databind.node.ObjectNode;

import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.AbstractConfigClass;

public interface IConfigManager {
	/*****
	 * 通过key得到解析文件，这个留给业务系统来实现，如果有缓存可以给缓存里拿出返回
	 * 
	 * @param appKey
	 * @return
	 */
	public AbstractConfigClass getConfig(String appKey);

	/****
	 * 通过appKey获得对应的输入参数Bean
	 * 
	 * @param appKey
	 * @return
	 */
	public CusDynaBean getInputBean(String appKey);

	/**
	 * 通过参数得到输入参数Bean,它的appkey在ControlInfo-》requestCommand中,比getInputBean多一步,组装input参数
	 * 
	 * @param inputBody
	 * @return
	 */
	public CusDynaBean getInputBeanInputBody(ObjectNode inputBody);

	/***
	 * 通过参数得到appkey
	 * 
	 * @param inputBody
	 * @return
	 */
	public String getAppkeyByInputBody(ObjectNode inputBody);

	/***
	 * 重新加载配置,实现热加载
	 */
	public void refresh();
}
