/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.beans.property;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;

@SuppressWarnings("rawtypes")
public class ObjectHandler extends BasicHandler {

	private static final long serialVersionUID = 946199084482013912L;
	private final static Logger logger = LoggerFactory.getLogger(ObjectHandler.class);

	public ObjectHandler(String name) {
		super(name);
	}

	public ObjectHandler(String name, Class type) {
		super(name, type);
	}

	public ObjectHandler(String name, Class type, Class contentType) {
		super(name, type, contentType);
	}

	@Override
	protected Result checkSingleValue(Object value) {
		if(!"java.math.BigDecimal".equals(value.getClass().getName())&& !ReflectAssist.isPrimitieClass(value.getClass())) {
			logger.error("[{}]的类型不匹配，应该是8种基本类型,但传进来的参数是[{}]类型", name, value.getClass().getName());
			return new Result(ExceptAll.Param_typenofit);
		}
		if (!isNull() && (value == null || StringUtils.isBlank(StringUtil.hasNull(String.valueOf(value))))) {
			logger.error("[{}]不允许传空值", name);
			return new Result(ExceptAll.project_nonull);
		}
		return Result.getSuc();
	}

	// 没有默认值
	@Override
	public Object getSingleDefaultColValue() {
		return null;
	}

	@Override
	protected Object singleObjToJson(Object json) {
		return String.valueOf(json);
	}

	@Override
	protected Object jsonTosingleObj(Object obj) {
		return obj;
	}

	@Override
	protected Object mockObj() {
		return 1;//因为可以容许多种类型
	}

}
