/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.beans.property;

import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.beans.CusDynaClass;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;

@SuppressWarnings("rawtypes")
@Slf4j
public class DynaBeanHandler extends BasicNoHandler {
	private static final long serialVersionUID = 1L;

	private CusDynaClass valueClass;

	public CusDynaClass getValueClass() {
		return this.valueClass;
	}

	public DynaBeanHandler(String name, DynaClass valueClass) {
		super(name, valueClass);
		this.valueClass = (CusDynaClass) valueClass;
	}

	public DynaBeanHandler(String name, Class type, DynaClass valueClass) {
		super(name, type, valueClass.getClass());
		this.valueClass = (CusDynaClass) valueClass;
	}

	@Override
	protected Result checkSingleValue(Object value) {
		if (value == null) {// 2020-05-10 没有值检查成功，防止后面类型检查空指针
			return Result.getSuc();
		}
		String strict = getAttributeValue(ColProperty.strict);// 是否执行严格Class比较，服务端与客户端解析相同的xml的Class也不相同，如controlinfo等
		boolean isStrict = true;
		if (StringUtils.isNotBlank(strict)) {
			isStrict = Boolean.parseBoolean(strict);
		}
		boolean isSame = false;
		if (isStrict) {
			isSame = ((CusDynaBean) value).getDynaClass() == this.valueClass;
		} else {
			isSame = isSameClass(value);
		}
		if (!isSame) {
			log.error("[{}]的类型不匹配，应该是CusDynaClass,但传进来的参数是[{}]类型", name, value.getClass().getName());
			return new Result(ExceptAll.Param_typenofit);
		}
		return Result.getSuc();
	}

	private boolean isSameClass(Object value) {
		HashMap<String, AbstractDynaClassProperty> thisProps = this.valueClass.getAllPropertys();
		AbstractDynaClassProperty[] valProps = ((CusDynaBean) value).getDynaClass().getDynaProperties();
		if (thisProps.size() != valProps.length) {
			return false;
		}
		boolean ret = true;
		for (AbstractDynaClassProperty valprop : valProps) {
			if (!thisProps.keySet().contains(valprop.getName())) {
				ret = false;
				break;
			}
		}
		return ret;
	}

	@Override
	protected Object jsonTosingleObj(Object obj) {
		ObjectNode retobj = (ObjectNode) obj;
		CusDynaBean dynabean = this.valueClass.newInstance();
		for (Iterator<String> iterator =retobj.fieldNames(); iterator.hasNext();) {
			String	 key = iterator.next();
			AbstractDynaClassProperty prop = (AbstractDynaClassProperty) dynabean.getDynaClass().getDynaProperty(key);
			if (prop != null) {
				prop.setValueByJson(dynabean, retobj.get(key));
			}
			
		}
		return dynabean;
	}

	@Override
	public Object getSingleDefaultColValue() {
		String defaultValue = getAttriValue(ColProperty.defaultValue);
		if (StringUtils.isNotBlank(defaultValue)) {
			ObjectNode json = JSONUtil.parserStr(new ObjectMapper(),defaultValue);
			CusDynaBean db = (CusDynaBean) this.jsonTosingleObj(json);
			return db;
		} else {
			return null;
		}
	}

	@Override
	protected Object singleObjToJson(Object singleValue) {
		if (singleValue == null) {
			return null;
		}
		ObjectNode retobj = JsonNodeFactory.instance.objectNode();
		CusDynaBean cus = (CusDynaBean) singleValue;
		AbstractDynaClassProperty[] props = cus.getDynaClass().getDynaProperties();

		for (AbstractDynaClassProperty prop : props) {
			Object propValue = cus.get(prop.getName());
			retobj.putPOJO(prop.getName(), prop.singleObjToJson(propValue));
		}
		return retobj;
	}

	@Override
	protected Object mockObj() {
		CusDynaBean dynabean = this.valueClass.newInstance();
		HashMap<String, AbstractDynaClassProperty> allPropertys = this.valueClass.getAllPropertys();
		for (String key : allPropertys.keySet()) {
			AbstractDynaClassProperty prop = (AbstractDynaClassProperty) dynabean.getDynaClass().getDynaProperty(key);
			prop.setValueByMock(dynabean);
		}
		return dynabean;
	}

}
