/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.beans.property;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;

@SuppressWarnings("rawtypes")
public class DoubleHandler extends BasicHandler {

	private static final long serialVersionUID = 946199084482013912L;
	private final static Logger logger = LoggerFactory.getLogger(DoubleHandler.class);

	public DoubleHandler(String name) {
		super(name);
	}

	public DoubleHandler(String name, Class type) {
		super(name, type);
	}

	public DoubleHandler(String name, Class type, Class contentType) {
		super(name, type, contentType);
	}

	@Override
	protected Result checkSingleValue(Object value) {
		if (value != null && !(value instanceof Double)) {
			logger.error("[{}]的类型不匹配，应该是Double,但传进来的参数是[{}]类型", name, value.getClass().getName());
			return new Result(ExceptAll.Param_typenofit);
		}
		if (!isNull() && (value == null || StringUtils.isBlank(StringUtil.hasNull(String.valueOf(value))))) {
			logger.error("[{}]不允许传空值", name);
			return new Result(ExceptAll.project_nonull);
		}
		if (StringUtils.isNotBlank(getAttriValue(ColProperty.min))
				&& Double.parseDouble(getAttriValue(ColProperty.min)) > (Double) value) {
			logger.error("[{}]比最小值[{}]还小", name, getAttriValue(ColProperty.min));
			return new Result(ExceptAll.project_overflow);
		}
		if (StringUtils.isNotBlank(getAttriValue(ColProperty.max))
				&& Double.parseDouble(getAttriValue(ColProperty.max)) < (Double) value) {
			logger.error("[{}]比最大值[{}]还大", name, getAttriValue(ColProperty.max));
			return new Result(ExceptAll.project_overflow);
		}
		return Result.getSuc();
	}

	@Override
	public Object getSingleDefaultColValue() {
		String defaultValue = getAttriValue(ColProperty.defaultValue);
		if (StringUtils.isBlank(defaultValue)) {
			return null;
		} else {
			return Double.parseDouble(defaultValue);
		}

	}

	@Override
	protected Object singleObjToJson(Object json) {
		return String.valueOf(json);
	}

	@Override
	protected Object jsonTosingleObj(Object obj) {
		return new Double(String.valueOf(obj));
	}

	@Override
	protected Object mockObj() {
		return 1.0d;
	}

}
