/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.annotation.spring;

import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;

import org.springframework.context.ApplicationContext;

/***
 * 由spring的bean名决定busi实例
 * 
 * @author zhoujunhui
 *
 */
public class SpringBusiManager implements IBusiManager {
	private final ApplicationContext context;

	public SpringBusiManager(ApplicationContext context) {
		this.context = context;
	}

	@Override
	public IBusiApp getBean(String appKey) {
		IBusiApp retobj = (IBusiApp) context.getBean(appKey);
		return retobj;
	}

	@Override
	public void refresh() {
		throw new IllegalAccessError("暂不支持热加载");
	}

}
