/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.annotation.spring;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.param.Response;
import net.wicp.tams.common.metrics.annotation.HistogramTams;
import net.wicp.tams.common.metrics.annotation.MeterTams;
import net.wicp.tams.common.web.J2EEAssist;

/***
 * 默认的处理器
 * 
 * @author zhoujunhui
 *
 */
@Slf4j
public class ConnectorServlet extends HttpServlet {
	private static final long serialVersionUID = -1578783960005731596L;

	@Autowired
	private CommonService commonService;
	@Autowired
	public IConfigManager configmanager;
	@MeterTams(isThisClass = true, value = "AllErrorMeter")
	private Meter errorMeter;// 调用错误
	@HistogramTams(isThisClass = true, value = "AllHistogram")
	private Histogram histogram;

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		String requestBody = IOUtil.slurp(req.getInputStream());
		ObjectNode params = null;
		try {
			params = JSONUtil.parserStr(new ObjectMapper(), requestBody);
		} catch (Exception e) {
			log.error("参数格式错误", e);
			CusDynaBean retBean = ConfigInstance.getInstance().getNullOutBean(ExceptAll.param_error);
			retBean.setResult(ExceptAll.param_error, e.getMessage());
			resp.setStatus(ExceptAll.param_error.getHttpCode());
			J2EEAssist.returnJsonResponse(resp, retBean.getJsonObj().toString());
			errorMeter.mark();
			return;
		}
		CusDynaBean inputBean = null;
		resp.setCharacterEncoding("UTF-8");
		try {
			inputBean = configmanager.getInputBeanInputBody(params);
		} catch (Throwable e) {
			log.error("设置input值失败", e);
			CusDynaBean retBean = ConfigInstance.getInstance().getNullOutBean(ExceptAll.project_undefined);
			retBean.setResult(ExceptAll.project_undefined, e.getMessage());
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			J2EEAssist.returnJsonResponse(resp, retBean.getJsonObj().toString());
			errorMeter.mark();
			return;
		}
		long beginTime = System.currentTimeMillis();
		CusDynaBean outbean = commonService.exe(inputBean);
		histogram.update(System.currentTimeMillis() - beginTime);// 直方图
		if (outbean == null) {
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			outbean = configmanager.getConfig(configmanager.getAppkeyByInputBody(params))
					.newOutBean(ExceptAll.project_undefined);
			outbean.set(Response.errMsg, "返回了空值");
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			errorMeter.mark();
		} else {
			Object httpstatusobj = outbean.get(Response.http);
			log.info("-----------------------------http状态:" + httpstatusobj + "-----------------------");
			int status = ExceptAll.getHttp(String.valueOf(httpstatusobj));
			resp.setStatus(status);
			if (status != 200) {
				errorMeter.mark();
			}
		}
		J2EEAssist.returnJsonResponse(resp, outbean.getJsonObj().toString());
	}
}
