/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.connector.annotation;

import java.lang.annotation.Annotation;

import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.spring.autoconfig.beans.TypeBean;

public class CacheConnectorDo extends TypeBean<Object> {

	public CacheConnectorDo(Annotation annotationInst) {
		super(annotationInst);
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		CacheConnector cacheConnector = (CacheConnector) super.annotationInst;
		if (cacheConnector != null) {
			CommonService commonService = this.applicationContext.getBean(CommonService.class);
			String[] beanNamesForType = this.applicationContext.getBeanNamesForType(super.getRef().getClass());
			for (String beanName : beanNamesForType) {
				commonService.needCacheMap.put(beanName, cacheConnector.expire());
			}
		}
	}

}
