/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.property.BasicNoHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanHandler
extends BasicNoHandler {
    private static final Logger log = LoggerFactory.getLogger(JavaBeanHandler.class);
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JavaBeanHandler.class);
    private Class beanClass;

    public JavaBeanHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
        this.beanClass = contentType;
    }

    public JavaBeanHandler(String name, Class type) {
        super(name, type);
        this.beanClass = type;
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value == null || this.beanClass != null && value.getClass().isAssignableFrom(this.beanClass)) {
            return Result.getSuc();
        }
        if (this.beanClass == null) {
            logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u503c[{}]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7c7b\u578b", (Object)this.name, value);
            return new Result((IExcept)ExceptAll.Param_typenofit);
        }
        logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f[{}],\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u57fa\u672c\u7c7b\u578b", new Object[]{this.name, this.beanClass.getName(), value.getClass().getName()});
        return new Result((IExcept)ExceptAll.Param_typenofit);
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            JSONObject json = JSONObject.parseObject((String)defaultValue);
            Object retdefaultobj = this.jsonTosingleObj(json);
            return retdefaultobj;
        }
        return null;
    }

    @Override
    protected Object singleObjToJson(Object json) {
        String jsonstr = JSONObject.toJSONString((Object)json);
        return JSONObject.parse((String)jsonstr);
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        JSONObject inputobj = (JSONObject)obj;
        Object retobj = inputobj.toJavaObject(this.beanClass);
        return retobj;
    }

    private void setMock(Object bean, String filedName, Class type) {
        Object param = null;
        if (type == String.class) {
            param = "abc";
        } else if (type == Integer.TYPE || type == Integer.class) {
            param = 1;
        } else if (type == Long.TYPE || type == Long.class) {
            param = 1L;
        } else if (type == Byte.TYPE || type == Byte.class) {
            param = Byte.parseByte("1");
        } else if (type == Character.TYPE || type == Character.class) {
            param = Character.valueOf("1".charAt(0));
        } else if (type == Float.TYPE || type == Float.class) {
            param = Float.valueOf(Float.parseFloat("1"));
        } else if (type == Double.TYPE || type == Double.class) {
            param = Double.parseDouble("1.0");
        } else if (type == Short.TYPE || type == Short.class) {
            param = Short.parseShort("1");
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            param = true;
        } else if (Date.class.isAssignableFrom(type)) {
            param = new Date();
        } else if (Enum.class.isAssignableFrom(type)) {
            try {
                Object[] enumConstants = type.getEnumConstants();
                if (ArrayUtils.isNotEmpty((Object[])enumConstants)) {
                    param = enumConstants[0];
                }
            }
            catch (Exception exception) {}
        } else if (type == BigDecimal.class) {
            try {
                param = new BigDecimal("1.0");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            BeanUtils.setProperty((Object)bean, (String)filedName, (Object)param);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    protected Object mockObj() {
        Field[] fs = this.beanClass.getDeclaredFields();
        Object bean = null;
        try {
            bean = this.beanClass.newInstance();
        }
        catch (Exception e1) {
            log.error("\u9700\u8981\u65e0\u53c2\u7684\u6784\u9020\u51fd\u6570:", (Throwable)e1);
        }
        for (Field f : fs) {
            try {
                ParameterizedType pt;
                Type fc;
                Class<Object> fieldClazz = f.getType();
                if (fieldClazz.isPrimitive()) {
                    this.setMock(bean, f.getName(), fieldClazz);
                }
                if (fieldClazz.getName().startsWith("java.lang")) {
                    this.setMock(bean, f.getName(), fieldClazz);
                }
                if (fieldClazz.isAssignableFrom(List.class)) {
                    fc = f.getGenericType();
                    if (fc == null || !(fc instanceof ParameterizedType)) continue;
                    pt = (ParameterizedType)fc;
                    Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                    Object obj = genericClazz.newInstance();
                    BeanUtils.setProperty(bean, (String)f.getName(), obj);
                    continue;
                }
                if (fieldClazz.isAssignableFrom(Map.class)) {
                    fc = f.getGenericType();
                    if (fc == null || !(fc instanceof ParameterizedType)) continue;
                    pt = (ParameterizedType)fc;
                    Class param0 = (Class)pt.getActualTypeArguments()[0];
                    Class param1 = (Class)pt.getActualTypeArguments()[1];
                    HashMap values = new HashMap();
                    Object obj = param0.newInstance();
                    Object obj2 = param1.newInstance();
                    values.put(obj, obj2);
                    BeanUtils.setProperty(bean, (String)f.getName(), values);
                    continue;
                }
                if (!fieldClazz.isArray()) continue;
                Object obj = fieldClazz.getComponentType().newInstance();
                BeanUtils.setProperty(bean, (String)f.getName(), (Object)new Object[]{obj});
            }
            catch (Exception e) {
                log.error("setmockdata error:", (Throwable)e);
            }
        }
        return bean;
    }
}

