/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import java.io.UnsupportedEncodingException;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.property.BasicNoHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesHandler
extends BasicNoHandler {
    private static final long serialVersionUID = 8868123823119037087L;
    private static final Logger logger = LoggerFactory.getLogger(BytesHandler.class);

    public BytesHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    public BytesHandler(String name, Class type) {
        super(name, type);
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value.getClass().isAssignableFrom(byte[].class)) {
            return Result.getSuc();
        }
        logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fbyte[],\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u57fa\u672c\u7c7b\u578b", (Object)this.name, (Object)value.getClass().getName());
        return new Result((IExcept)ExceptAll.Param_typenofit);
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            return null;
        }
        return defaultValue.getBytes();
    }

    @Override
    protected Object singleObjToJson(Object json) {
        byte[] tempobj = (byte[])json;
        try {
            return new String(tempobj, Conf.get((String)"common.apiext.encode"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(String.format("\u5b57\u6bb5[{}]\u4e8c\u8fdb\u5236\u8f6c\u4e3astring\u5bf9\u8c61\u51fa\u9519", this.name), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        String tempstr = (String)obj;
        try {
            return tempstr.getBytes(Conf.get((String)"common.apiext.encode"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(String.format("\u5b57\u6bb5[{}] String\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u65f6\u51fa\u9519", this.name), (Throwable)e);
            return null;
        }
    }

    @Override
    protected Object mockObj() {
        String tempstr = this.name + "_mock";
        try {
            return tempstr.getBytes(Conf.get((String)"common.apiext.encode"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(String.format("\u5b57\u6bb5[{}] String\u8f6c\u4e3a\u4e8c\u8fdb\u5236\u65f6\u51fa\u9519", this.name), (Throwable)e);
            return null;
        }
    }
}

