/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.annotation.spring;

import javax.servlet.Servlet;
import net.wicp.tams.common.connector.annotation.spring.ConnectorServlet;
import net.wicp.tams.common.connector.annotation.spring.SpringBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=0x7FFFFFFF)
public class ConnectionConfig {
    @Bean
    @ConditionalOnMissingBean
    protected IConfigManager createIConfigManager() {
        KeyConfigManager manage = new KeyConfigManager();
        return manage;
    }

    @Bean
    protected CommonService createExecutor(ApplicationContext context, IConfigManager configManager, AbsPool absPool) {
        CommonService executor = new CommonService();
        SpringBusiManager busi = new SpringBusiManager(context);
        executor.setBusiManager(busi);
        executor.setConfigManager(configManager);
        executor.setAbsPool(absPool);
        return executor;
    }

    @Bean
    public ConnectorServlet servlet() {
        return new ConnectorServlet();
    }

    @Bean
    public ServletRegistrationBean confServlet(ConnectorServlet servlet) {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, true, new String[]{"/connector"});
        return registration;
    }
}

