package net.wicp.tams.common.connector.executor.busi;

import java.util.HashMap;
import java.util.Map;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBusiManager implements IBusiManager {
	private final static Logger logger = LoggerFactory.getLogger(FileBusiManager.class);
	private static Map<String, IBusiApp> busimap = new HashMap<String, IBusiApp>();

	@Override
	public IBusiApp getBean(String appKey) {
		if (FileConfigManager.serviceProp.isEmpty() || StringUtil.isNull(appKey)) {
			throw new IllegalArgumentException("");
		}
		String classnameValue = FileConfigManager.serviceProp.getProperty(String.format("%s.%s", appKey, "classname"));
		if (StringUtil.isNull(classnameValue)) {
			throw new IllegalArgumentException("没有定义" + appKey + "对应的classname");
		}
		IBusiApp busi = busimap.get(appKey);
		if (busi == null) {
			try {
				busi = (IBusiApp) Class.forName(classnameValue).newInstance();
				busimap.put(appKey, busi);
			} catch (Exception e) {
				logger.error("------加载" + appKey + "对应的class错误------", e);
				throw new IllegalArgumentException("------加载" + appKey + "对应的class错误------");
			}
		}
		return busi;
	}

	@Override
	public synchronized void refresh() {
		busimap.clear();	
	}

}
