/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.annotation.spring.service;

import java.util.ArrayList;
import java.util.Set;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.annotation.spring.service.Cmd;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.exception.ProjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="connector.cache")
public class ConnectorCache
implements IBusiApp {
    private static final Logger log = LoggerFactory.getLogger(ConnectorCache.class);
    @Autowired
    private CommonService commonService;

    @Override
    public CusDynaBean exe(CusDynaBean inputBean, CusDynaBean outBeanOri) throws ProjectException {
        Cmd cmd = inputBean.getByType(Cmd.class, "cmd");
        String appkey = inputBean.getStrValueByName("appkey");
        if ((cmd == Cmd.add || cmd == Cmd.del) && StringUtil.isNull((Object)appkey)) {
            outBeanOri.setResult(Result.getError((String)"add\u548cdel\u9700\u8981\u4f20\u5165appkey"));
            return outBeanOri;
        }
        switch (cmd) {
            case add: {
                Integer expire = (Integer)inputBean.get("expire");
                this.commonService.needCacheMap.put(appkey, expire);
                break;
            }
            case del: {
                this.commonService.needCacheMap.remove(appkey);
                break;
            }
            case clean: {
                this.commonService.needCacheMap.clear();
                break;
            }
            case query: {
                Set<String> keySet = this.commonService.needCacheMap.keySet();
                ArrayList<CusDynaBean> inputlist = new ArrayList<CusDynaBean>();
                for (String key : keySet) {
                    CusDynaBean tempbean = outBeanOri.newCusDynaBean("caches");
                    tempbean.set("appkey", key);
                    tempbean.set("expire", this.commonService.needCacheMap.get(key));
                    inputlist.add(tempbean);
                }
                outBeanOri.set("caches", inputlist);
                break;
            }
        }
        outBeanOri.setResult(Result.getSuc());
        log.info("\u7f13\u5b58\u5df2\u66f4\u65b0");
        return outBeanOri;
    }
}

