/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.constant.ColGType;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.connector.constant.ColType;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public static synchronized XMLReader getXMLReader() {
        try {
            SAXParser parser = saxFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            return parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException se) {
            return null;
        }
    }

    public static final Document parserDocment(String src) throws ProjectException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(src)));
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u89e3\u6790XML\u6587\u6863\u9519\u8bef");
        }
    }

    public static Element getElementByTagName(Document doc, String tagName) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static final String findValueByAttrName(ConfigurationNode node, String attrName) {
        List typeAry = node.getAttributes(attrName);
        if (CollectionUtils.isEmpty((Collection)typeAry)) {
            return null;
        }
        return String.valueOf(((DefaultConfigurationNode)typeAry.get(0)).getValue());
    }

    public static String getElementValue(Element element) {
        if (element.hasChildNodes()) {
            return element.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final ConfigurationNode getFirstNodeByNodeName(ConfigurationNode node, String name) {
        List nodes = node.getChildren(name);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return null;
        }
        return (ConfigurationNode)nodes.get(0);
    }

    public static Object getValueByXpath(Object beanObj, String xpath) {
        JXPathContext context = JXPathContext.newContext((Object)beanObj);
        return context.getValue(xpath);
    }

    public static List<String> getChildValues(ConfigurationNode superNode, String subNodeName) {
        ArrayList<String> retlist = new ArrayList<String>();
        List includeList = superNode.getChildren(subNodeName);
        if (CollectionUtils.isEmpty((Collection)includeList)) {
            return retlist;
        }
        for (ConfigurationNode configurationNode : includeList) {
            retlist.add(String.valueOf(configurationNode.getValue()));
        }
        return retlist;
    }

    public static void mergexml(XMLConfiguration xml, String path, String addStr) throws ConfigurationException {
        ByteArrayInputStream addStrIn = new ByteArrayInputStream(addStr.getBytes());
        XMLConfiguration addConfig = new XMLConfiguration();
        addConfig.load((InputStream)addStrIn);
        int startint = StringUtil.isNotNull((Object)path) ? path.lastIndexOf(".") : -1;
        String key = path.substring(startint + 1);
        xml.addNodes(key, (Collection)addConfig.getRoot().getChildren());
    }

    public static Document createXmlDoc(Class<?> classz) {
        Map contextType = ReflectAssist.getAllType(classz);
        try {
            Document docment = XmlUtil.parserDocment("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<InterFaceMapping>\r\n\t<PropertyIn>\r\n\t</PropertyIn>\r\n\t<PropertyOut>\r\n\t</PropertyOut>\r\n</InterFaceMapping>");
            if (MapUtils.isEmpty((Map)contextType)) {
                return docment;
            }
            Element propertyInEle = XmlUtil.getElementByTagName(docment, "PropertyIn");
            for (String key : contextType.keySet()) {
                ColType colType;
                ColType colType2;
                String name;
                Element tempnode = docment.createElement("COL");
                tempnode.setAttribute("name", key);
                tempnode.setAttribute("alias", key);
                tempnode.setNodeValue(key);
                Class[] classtype = (Class[])contextType.get(key);
                if (classtype[0].isPrimitive()) {
                    name = classtype[0].getTypeName();
                    colType2 = ColType.string;
                    if ("void".equals(name)) continue;
                    if ("boolean".equals(name)) {
                        colType2 = ColType.string;
                    } else if ("byte".equals(name)) {
                        colType2 = ColType.bytes;
                    } else if ("char".equals(name)) {
                        colType2 = ColType.string;
                    } else if ("double".equals(name)) {
                        colType2 = ColType.doubler;
                    } else if ("float".equals(name)) {
                        colType2 = ColType.doubler;
                    } else if ("int".equals(name)) {
                        colType2 = ColType.integer;
                    } else if ("long".equals(name)) {
                        colType2 = ColType.string;
                    } else if ("short".equals(name)) {
                        colType2 = ColType.integer;
                    }
                    tempnode.setAttribute("type", colType2.name());
                } else if (classtype[0].getName().startsWith("java.lang")) {
                    name = classtype[0].getTypeName();
                    colType2 = XmlUtil.typestrToDynabean(name);
                    tempnode.setAttribute("type", colType2.name());
                } else if (classtype[0].isAssignableFrom(List.class)) {
                    tempnode.setAttribute("gtype", ColGType.list.name());
                    colType = XmlUtil.typestrToDynabean(classtype[1].getName());
                    tempnode.setAttribute("type", colType.name());
                } else if (classtype[0].isAssignableFrom(Map.class)) {
                    tempnode.setAttribute("gtype", ColGType.map.name());
                    tempnode.setAttribute("type", ColType.javaBean.name());
                    tempnode.setAttribute("className", classtype[2].getName());
                } else if (classtype[0].isArray()) {
                    tempnode.setAttribute("gtype", ColGType.array.name());
                    colType = XmlUtil.typestrToDynabean(classtype[1].getName());
                    tempnode.setAttribute("type", colType.name());
                } else if ("java.util.Date".equals(classtype[0].getName())) {
                    tempnode.setAttribute("type", ColType.datetime.name());
                } else {
                    colType = XmlUtil.typestrToDynabean(classtype[0].getName());
                    tempnode.setAttribute("type", colType.name());
                    tempnode.setAttribute(ColProperty.className.name(), classtype[0].getName());
                }
                propertyInEle.appendChild(tempnode);
            }
            return docment;
        }
        catch (ProjectException e) {
            log.error("\u6587\u6863\u51fa\u9519", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error("\u6587\u6863\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private static ColType typestrToDynabean(String name) {
        ColType retColType = ColType.javaBean;
        if (name.startsWith("java.lang")) {
            retColType = "java.lang.Boolean".equals(name) ? ColType.string : ("java.lang.Byte".equals(name) ? ColType.bytes : ("java.lang.Character".equals(name) ? ColType.string : ("java.lang.Double".equals(name) ? ColType.doubler : ("java.lang.Float".equals(name) ? ColType.doubler : ("java.lang.Integer".equals(name) ? ColType.integer : ("java.lang.Long".equals(name) ? ColType.string : ("java.lang.Short".equals(name) ? ColType.integer : ColType.string)))))));
        }
        return retColType;
    }

    public static Result writeXmlFile(Document document, String filepath) {
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            String path = PathType.getPath((String)filepath, (boolean)false);
            tf.transform(new DOMSource(document), new StreamResult(new File(path)));
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u5199xml\u5931\u8d25", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    static {
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
    }
}

