package net.wicp.tams.common.connector.beans;

import java.util.HashMap;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.common.connector.beans.property.DynaBeanHandler;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang3.ArrayUtils;

public class CusDynaClass extends BasicDynaClass implements Cloneable {
	private static final long serialVersionUID = 1L;
	private transient java.util.HashMap<String, AbstractDynaClassProperty> alaisMapping = new HashMap<String, AbstractDynaClassProperty>();

	/**
	 * 构造函数,私有
	 */
	@SuppressWarnings("rawtypes")
	private CusDynaClass(String arg0, Class arg1, DynaProperty[] arg2) {
		super(arg0, arg1, arg2);
	}

	/**
	 * 工厂方法产生Class
	 */
	public static CusDynaClass createCusDynaClass(String name, AbstractDynaClassProperty[] propertyes) {
		propertyes = propertyes == null ? new AbstractDynaClassProperty[0] : propertyes;
		CusDynaClass retDynaClass = new CusDynaClass(name, CusDynaBean.class, propertyes);
		return retDynaClass;
	}

	/**
	 * 通过名字找到字段
	 */
	public AbstractDynaClassProperty findProperty(String name) {
		if (this.propertiesMap.containsKey(name)) {
			return (AbstractDynaClassProperty) this.propertiesMap.get(name);
		}
		return null;
	}

	/***
	 * 通过指定路径的属性定义
	 * 
	 * @param path
	 * @return
	 */
	public AbstractDynaClassProperty findPropertyByPath(String path) {
		String[] splits = path.split("\\.");
		if (ArrayUtils.isEmpty(splits)) {
			return null;
		}
		if (splits.length == 1) {
			return this.findProperty(splits[0]);
		}
		AbstractDynaClassProperty prop = this.findProperty(splits[0]);
		if (prop instanceof DynaBeanHandler) {
			String subPath = CollectionUtil.arrayJoin(ArrayUtils.subarray(splits, 1, splits.length), ".");
			CusDynaClass propClass = ((DynaBeanHandler) prop).getValueClass();
			return propClass.findPropertyByPath(subPath);
		} else {
			throw new ProjectExceptionRuntime(ExceptAll.Param_typenofit, path + "对应的属性不可用");
		}
	}

	/**
	 * 通过别名找到字段
	 */
	public AbstractDynaClassProperty findPropertyByAlais(String alais) {
		return this.alaisMapping.containsKey(alais) ? this.alaisMapping.get(alais) : null;
	}

	public HashMap<String, AbstractDynaClassProperty> getAllPropertys() {
		HashMap<String, AbstractDynaClassProperty> ret = new HashMap<>();
		for (String cla : this.propertiesMap.keySet()) {
			ret.put(cla, (AbstractDynaClassProperty) this.propertiesMap.get(cla));
		}
		return ret;
	}

	/****
	 * 得到属性,不能改为getDynaProperty，会死循环
	 * 
	 * @param name 属性名
	 */
	public AbstractDynaClassProperty getCusDynaProperty(final String name) {
		AbstractDynaClassProperty prop = (AbstractDynaClassProperty) this.getDynaProperty(name);
		return prop;
	}

	@Override
	protected CusDynaClass clone() throws CloneNotSupportedException {
		return (CusDynaClass) super.clone();
	}

	@Override
	public CusDynaBean newInstance() {
		CusDynaBean dynaBean = new CusDynaBean(this);
		return dynaBean;
	}

	@Override
	public AbstractDynaClassProperty[] getDynaProperties() {
		return (AbstractDynaClassProperty[]) super.getDynaProperties();
	}

}
