package net.wicp.tams.common.connector.annotation.spring;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.redis.pool.AbsPool;

@Configuration
@Order(Ordered.LOWEST_PRECEDENCE)
public class ConnectionConfig {

	@Bean
	@ConditionalOnMissingBean
	protected IConfigManager createIConfigManager() {
		IConfigManager manage = new KeyConfigManager();
		return manage;
	}

	@Bean
	protected CommonService createExecutor(ApplicationContext context, IConfigManager configManager,
			AbsPool absPool) {
		CommonService executor = new CommonService();
		IBusiManager busi = new SpringBusiManager(context);
		executor.setBusiManager(busi);
		executor.setConfigManager(configManager);
		executor.setAbsPool(absPool);
		return executor;
	}

	@Bean
	public ConnectorServlet servlet() {
		return new ConnectorServlet();
	}

	// 兼容springboot1 ,不用ServletRegistrationBean<Servlet>
	@Bean
	public ServletRegistrationBean confServlet(ConnectorServlet servlet) {
		ServletRegistrationBean registration = new ServletRegistrationBean(servlet, true, Conf.get("common.connector.context"));
		// registration.setEnabled(true);
		// registration.addUrlMappings("/connector");// connector的默认处理器
		return registration;
	}
}
