package net.wicp.tams.common.connector.executor;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.AbstractConfigClass;

public interface IConfigManager {
	/*****
	 * 通过key得到解析文件，这个留给业务系统来实现，如果有缓存可以给缓存里拿出返回
	 * 
	 * @param appKey
	 * @return
	 */
	public AbstractConfigClass getConfig(String appKey);

	/****
	 * 通过appKey获得对应的输入参数Bean
	 * 
	 * @param appKey
	 * @return
	 */
	public CusDynaBean getInputBean(String appKey);

	/**
	 * 通过参数得到输入参数Bean,它的appkey在ControlInfo-》requestCommand中,比getInputBean多一步,组装input参数
	 * 
	 * @param inputBody
	 * @return
	 */
	public CusDynaBean getInputBeanInputBody(JSONObject inputBody);

	/***
	 * 通过参数得到appkey
	 * 
	 * @param inputBody
	 * @return
	 */
	public String getAppkeyByInputBody(JSONObject inputBody);

	/***
	 * 重新加载配置,实现热加载
	 */
	public void refresh();
}
