/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.executor.busi;

import net.wicp.tams.common.Plugin;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoadManager
implements IBusiManager {
    private static final Logger log = LoggerFactory.getLogger(ClassLoadManager.class);
    private final Plugin plugin;
    private final String[] packageBases;

    public ClassLoadManager(String dirpath, String ... packageBases) {
        this.plugin = new Plugin(dirpath, "net.wicp.tams.common.connector.executor.IBusiApp", Thread.currentThread().getContextClassLoader());
        this.packageBases = packageBases;
        Thread.currentThread().setContextClassLoader(this.plugin.getLoad().getClassLoader());
    }

    @Override
    public IBusiApp getBean(String appKey) {
        if (ArrayUtils.isNotEmpty((Object[])this.packageBases)) {
            for (String packageBase : this.packageBases) {
                String formatestr = packageBase.endsWith(".") ? "%s%s" : "%s.%s";
                String className = String.format(formatestr, packageBase, appKey);
                try {
                    Class classz = this.plugin.loadSingleByClassName(className);
                    IBusiApp retobj = (IBusiApp)classz.newInstance();
                    return retobj;
                }
                catch (Exception e) {
                    log.error("{}\u672a\u627e\u5230{}", (Object)packageBase, (Object)appKey);
                }
            }
        }
        return null;
    }

    @Override
    public void refresh() {
        this.plugin.refresh();
    }
}

