/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.beans.property.BasicHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(StringHandler.class);

    public StringHandler(String name) {
        super(name);
    }

    public StringHandler(String name, Class type) {
        super(name, type);
    }

    public StringHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    @Override
    protected Result checkSingleValue(Object value) {
        String errorMsg = null;
        if (value != null && !(value instanceof String)) {
            errorMsg = "[" + this.name + "]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fString,\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[" + value.getClass().getName() + "]\u7c7b\u578b";
        }
        String valueStr = StringUtil.hasNull((String[])new String[]{String.valueOf(value)});
        if (!this.isNull() && StringUtils.isBlank((CharSequence)valueStr)) {
            errorMsg = "[" + this.name + "]\u4e0d\u5141\u8bb8\u4f20\u7a7a\u503c";
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAttriValue(ColProperty.length)) && valueStr.length() > Integer.parseInt(this.getAttriValue(ColProperty.length))) {
            errorMsg = String.format("[%s]\u7684\u503c[%s]\u957f\u5ea6\u8d85\u8fc7\u5141\u8bb8\u7684\u6700\u5927\u503c", this.name, value);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAttriValue(ColProperty.format)) && value != null && !valueStr.matches(this.getAttriValue(ColProperty.format))) {
            errorMsg = "[" + this.name + "]\u683c\u5f0f\u4e0d\u6ee1\u8db3[" + this.getAttriValue(ColProperty.format) + "]";
        }
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            return Result.getSuc();
        }
        logger.error(errorMsg);
        return Result.getError((String)errorMsg);
    }

    @Override
    public Object getSingleDefaultColValue() {
        return this.getAttriValue(ColProperty.defaultValue);
    }

    @Override
    protected Object singleObjToJson(Object json) {
        String retstr = StringUtil.hasNull((String[])new String[]{String.valueOf(json)});
        if (StringUtils.isBlank((CharSequence)retstr)) {
            return null;
        }
        return retstr;
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        String value = String.valueOf(obj);
        return value;
    }

    @Override
    protected Object mockObj() {
        return "abc";
    }
}

