/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.executor.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.executor.IConfigManager;

public abstract class AbsConfigManager
implements IConfigManager {
    protected final String dir;
    private static final Map<String, AbstractConfigClass> configmap = new HashMap<String, AbstractConfigClass>();

    public AbsConfigManager() {
        this.dir = "connector";
    }

    public AbsConfigManager(String dir) {
        this.dir = dir;
    }

    @Override
    public CusDynaBean getInputBean(String appKey) {
        return this.getConfig(appKey).newInputBean();
    }

    @Override
    public CusDynaBean getInputBeanInputBody(JSONObject inputBody) {
        String appKey = inputBody.getJSONObject("ControlInfo").getString("requestCommand");
        CusDynaBean inputBean = this.getInputBean(appKey);
        inputBean.setByJson(inputBody);
        return inputBean;
    }

    @Override
    public String getAppkeyByInputBody(JSONObject inputBody) {
        String appKey = inputBody.getJSONObject("ControlInfo").getString("requestCommand");
        return appKey;
    }

    @Override
    public final AbstractConfigClass getConfig(String appKey) {
        AbstractConfigClass retobj = configmap.get(appKey);
        if (retobj == null && (retobj = this.createConfig(appKey)) != null) {
            configmap.put(appKey, retobj);
        }
        return retobj;
    }

    @Override
    public synchronized void refresh() {
        configmap.clear();
    }

    protected abstract AbstractConfigClass createConfig(String var1);
}

