/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.executor.busi;

import java.net.URLClassLoader;
import net.wicp.tams.common.Plugin;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoadManager
implements IBusiManager {
    private static final Logger log = LoggerFactory.getLogger(ClassLoadManager.class);
    private Plugin plugin;
    private final String dirpath;
    private final int maxLevel;
    private final String[] packageBases;

    public ClassLoadManager(String dirpath, int maxLevel, String ... packageBases) {
        this.dirpath = dirpath;
        this.maxLevel = maxLevel;
        this.packageBases = packageBases;
        this.init();
    }

    private void init() {
        this.plugin = new Plugin(this.dirpath, "net.wicp.tams.common.connector.executor.IBusiApp", IBusiApp.class.getClassLoader(), this.maxLevel);
    }

    @Override
    public IBusiApp getBean(String appKey) {
        if (ArrayUtils.isNotEmpty((Object[])this.packageBases)) {
            for (String packageBase : this.packageBases) {
                String formatestr = packageBase.endsWith(".") ? "%s%s" : "%s.%s";
                String className = String.format(formatestr, packageBase, appKey);
                try {
                    Class classz = this.plugin.loadSingleByClassName(className);
                    IBusiApp retobj = (IBusiApp)classz.newInstance();
                    return retobj;
                }
                catch (Exception e) {
                    log.error("{}\u672a\u627e\u5230{}", (Object)packageBase, (Object)appKey);
                }
            }
        }
        return null;
    }

    @Override
    public void refresh() {
        this.plugin.close();
        this.init();
    }

    public URLClassLoader getCloasLoader() {
        URLClassLoader classLoader = this.plugin.getLoad().getClassLoader();
        return classLoader;
    }
}

