/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.property.BasicHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(EnumHandler.class);
    private Class beanClass;

    public EnumHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
        this.beanClass = contentType;
    }

    public EnumHandler(String name, Class type) {
        super(name, type);
        this.beanClass = type;
    }

    @Override
    protected Result checkSingleValue(Object value) {
        String errorMsg = null;
        if (!this.isNull() && value == null) {
            errorMsg = "[" + this.name + "]\u4e0d\u5141\u8bb8\u4f20\u7a7a\u503c";
        } else if (value != null && !value.getClass().isAssignableFrom(this.beanClass)) {
            errorMsg = String.format("[%s]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f[%s],\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[%s]\u57fa\u672c\u7c7b\u578b", this.name, this.beanClass.getName(), value.getClass().getName());
        }
        if (StringUtils.isBlank(errorMsg)) {
            return Result.getSuc();
        }
        logger.error(errorMsg);
        return Result.getError(errorMsg);
    }

    @Override
    protected Object singleObjToJson(Object singleValue) {
        Enum tempobj = (Enum)singleValue;
        return tempobj == null ? null : tempobj.name();
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        return Enum.valueOf(this.beanClass, (String)obj);
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            return null;
        }
        return Enum.valueOf(this.beanClass, defaultValue);
    }

    @Override
    protected Object mockObj() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            Object[] enumConstants = this.beanClass.getEnumConstants();
            if (ArrayUtils.isNotEmpty((Object[])enumConstants)) {
                return enumConstants[0];
            }
            return null;
        }
        return Enum.valueOf(this.beanClass, defaultValue);
    }
}

