/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.executor.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.IConnInner;
import net.wicp.tams.common.connector.executor.IConnStr;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.others.RedisClient;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class CommonService
implements IConnInner,
IConnStr {
    private static final Logger log = LoggerFactory.getLogger(CommonService.class);
    private static Logger logger = LoggerFactory.getLogger(CommonService.class);
    private IBusiManager busiManager;
    private IConfigManager configManager;
    private String[] exclude = "none".equals(Conf.get((String)"common.connector.cache.exclude")) ? new String[]{} : Conf.get((String)"common.connector.cache.exclude").split(",");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CusDynaBean exeCommon(String appKey, CusDynaBean inputBean, boolean needCheck) {
        CusDynaBean retBean;
        block19: {
            Jedis jedis;
            block18: {
                String redisKey;
                boolean iscache;
                IBusiApp busiApp;
                CusDynaBean outBean;
                block17: {
                    if (this.busiManager == null) {
                        logger.error("busiManager\u9700\u8981\u4e1a\u52a1\u7cfb\u7edf\u7684\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4");
                        CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean((IExcept)ExceptAll.project_nonull);
                        return nullBean;
                    }
                    if (this.configManager == null) {
                        logger.error("configManager\u9700\u8981\u4e1a\u52a1\u7cfb\u7edf\u7684\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4");
                        CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean((IExcept)ExceptAll.project_nonull);
                        return nullBean;
                    }
                    AbstractConfigClass conf = this.configManager.getConfig(appKey);
                    CusDynaBean clientInfo = (CusDynaBean)((Object)inputBean.get("ControlInfo"));
                    if (needCheck && clientInfo == null) {
                        return conf.newOutBean((IExcept)ExceptAll.conn_nocontrol);
                    }
                    String msgId = clientInfo.getStrValueByName("msgId", String.valueOf(new Date().getTime()));
                    outBean = conf.newOutSuc(msgId);
                    busiApp = null;
                    try {
                        busiApp = this.busiManager.getBean(appKey);
                        if (busiApp == null) {
                            CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean((IExcept)ExceptAll.conn_nobean);
                            return nullBean;
                        }
                    }
                    catch (Exception e) {
                        String msg = "\u6ca1\u6709\u4e3a[" + appKey + "]\u627e\u5230\u5408\u9002\u7684\u4e1a\u52a1bean";
                        logger.error(msg, (Throwable)e);
                        CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean(new ProjectException((IExcept)ExceptAll.conn_nobean, msg));
                        return nullBean;
                    }
                    Result paramcheck = inputBean.checkFields();
                    if (!paramcheck.isSuc()) {
                        outBean.setResult(paramcheck.getExcept());
                        return outBean;
                    }
                    jedis = null;
                    iscache = false;
                    if (clientInfo != null && StringUtil.isNotNull((Object)clientInfo.getStrValueByName("cache"))) {
                        iscache = Boolean.getBoolean(clientInfo.getStrValueByName("cache"));
                    } else {
                        boolean defaultVal = Boolean.getBoolean(Conf.get((String)"common.connector.cache.default"));
                        if (defaultVal && !ArrayUtils.contains((Object[])this.exclude, (Object)appKey) || !defaultVal && ArrayUtils.contains((Object[])this.exclude, (Object)appKey)) {
                            iscache = true;
                        }
                    }
                    redisKey = "";
                    if (!iscache) break block17;
                    jedis = RedisClient.getConnection();
                    JSONObject jsonobj = inputBean.getJsonObj();
                    jsonobj.remove((Object)"ControlInfo");
                    String key = jsonobj.toJSONString();
                    redisKey = String.format("%s:%s:%s", "api", appKey, key.replace(":", "|"));
                    String redisstr = jedis.get(redisKey);
                    if (!StringUtil.isNotNull((Object)redisstr)) break block17;
                    outBean.setByJson(JSON.parseObject((String)redisstr));
                    CusDynaBean cusDynaBean = outBean;
                    RedisClient.returnResource((Jedis)jedis);
                    return cusDynaBean;
                }
                try {
                    Object httpstatusobj;
                    int status;
                    retBean = busiApp.exe(inputBean, outBean);
                    if (!iscache || (status = ExceptAll.getHttp((String)String.valueOf(httpstatusobj = outBean.get("http")))) != 200) break block18;
                    jedis.set(redisKey, outBean.getJsonObj().toJSONString());
                    jedis.expire(redisKey, 3600);
                }
                catch (ProjectException e) {
                    retBean = this.configManager.getConfig(appKey).newOutBean(e);
                    log.error("connection\u63a5\u53e3\u81ea\u5b9a\u4e49\u7684\u5f02\u5e38", (Throwable)e);
                    RedisClient.returnResource((Jedis)jedis);
                    break block19;
                }
                catch (Throwable e2) {
                    ProjectException reterror = new ProjectException((IExcept)ExceptAll.project_undefined, e2.getMessage());
                    retBean = this.configManager.getConfig(appKey).newOutBean(reterror);
                    log.error("connection\u63a5\u53e3\u672a\u6355\u83b7\u7684\u5f02\u5e38", e2);
                    {
                        catch (Throwable throwable) {
                            RedisClient.returnResource(jedis);
                            throw throwable;
                        }
                    }
                    RedisClient.returnResource((Jedis)jedis);
                }
            }
            RedisClient.returnResource((Jedis)jedis);
        }
        return retBean;
    }

    @Override
    public CusDynaBean exeNoCheck(String appKey, CusDynaBean inputBean) {
        return this.exeCommon(appKey, inputBean, false);
    }

    @Override
    public CusDynaBean exe(String appKey, CusDynaBean inputBean) {
        return this.exeCommon(appKey, inputBean, true);
    }

    @Override
    public CusDynaBean exe(CusDynaBean inputBean) {
        CusDynaBean clientInfo = (CusDynaBean)((Object)inputBean.get("ControlInfo"));
        String appkey = clientInfo.getStrValueByName("requestCommand");
        return this.exe(appkey, inputBean);
    }

    @Override
    public String exe(String appKey, String inputStr) {
        if (this.busiManager == null) {
            logger.error("busiManager\u9700\u8981\u4e1a\u52a1\u7cfb\u7edf\u7684\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4");
            CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean((IExcept)ExceptAll.project_nonull);
            return nullBean.getJsonObj().toJSONString();
        }
        AbstractConfigClass conf = this.configManager.getConfig(appKey);
        CusDynaBean inputBean = conf.newInputBean();
        inputBean.setByJson(JSONObject.parseObject((String)inputStr));
        CusDynaBean retBean = this.exe(appKey, inputBean);
        return retBean.getJsonObj().toJSONString();
    }

    public IBusiManager getBusiManager() {
        return this.busiManager;
    }

    public void setBusiManager(IBusiManager busiManager) {
        this.busiManager = busiManager;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(IConfigManager configManager) {
        this.configManager = configManager;
    }
}

