/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.property.BasicHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DateHandler.class);

    public DateHandler(String name) {
        super(name);
    }

    public DateHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    public DateHandler(String name, Class type) {
        super(name, type);
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value != null && !(value instanceof Date)) {
            logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fDate,\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u7c7b\u578b", (Object)this.name, (Object)value.getClass().getName());
            return new Result((IExcept)ExceptAll.Param_typenofit);
        }
        if (!this.isNull() && value == null) {
            logger.error("[{}]\u4e0d\u5141\u8bb8\u4f20\u7a7a\u503c", (Object)this.name);
            return new Result((IExcept)ExceptAll.project_nonull);
        }
        Date minDate = null;
        Date maxDate = null;
        try {
            SimpleDateFormat format = this.getFormat();
            minDate = StringUtils.isBlank((CharSequence)this.getAttriValue(ColProperty.min)) ? null : format.parse(this.getAttriValue(ColProperty.min));
            maxDate = StringUtils.isBlank((CharSequence)this.getAttriValue(ColProperty.max)) ? null : format.parse(this.getAttriValue(ColProperty.max));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (minDate != null && ((Date)value).before(minDate)) {
            logger.error("[{}]\u6bd4\u6700\u5c0f\u503c[{}]\u8fd8\u5c0f", (Object)this.name, (Object)this.getAttriValue(ColProperty.min));
            return new Result((IExcept)ExceptAll.project_overflow);
        }
        if (maxDate != null && ((Date)value).after(maxDate)) {
            logger.error("[{}]\u6bd4\u6700\u5927\u503c[{}]\u8fd8\u5927", (Object)this.name, (Object)this.getAttriValue(ColProperty.max));
            return new Result((IExcept)ExceptAll.project_overflow);
        }
        return Result.getSuc();
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            return null;
        }
        try {
            return this.getFormat().parse(defaultValue);
        }
        catch (ParseException e) {
            logger.error("\u8bbe\u7f6e\u9ed8\u8ba4\u503c{}\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a{}", (Object)defaultValue, (Object)this.getFormat().toString());
            return null;
        }
    }

    @Override
    protected Object singleObjToJson(Object json) {
        Date value = (Date)json;
        return this.getFormat().format(value);
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        String objStr = String.valueOf(obj);
        try {
            return this.getFormat().parse(objStr);
        }
        catch (ParseException e) {
            logger.error(String.format("\u5728json\u8f6c\u4e3a\u65f6\u95f4\u7c7b\u578b\u65f6\u9519\u8bef\uff0c\u503c%s\uff0c\u683c\u5f0f\u4e3a%s", objStr, this.getFormat().toString()), (Throwable)e);
            return null;
        }
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat format = StringUtils.isBlank((CharSequence)this.getAttriValue(ColProperty.format)) ? DateFormatCase.YYYY_MM_DD.getInstanc() : new SimpleDateFormat(this.getAttriValue(ColProperty.format));
        return format;
    }
}

