package net.wicp.tams.common.connector.executor.impl;

import java.util.Date;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.XMLNameSpace;
import net.wicp.tams.common.connector.constant.param.Request;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.IConnInner;
import net.wicp.tams.common.connector.executor.IConnStr;
import net.wicp.tams.common.exception.ExceptAll;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

public class CommonService implements IConnInner, IConnStr {
	private static Logger logger = LoggerFactory.getLogger(CommonService.class);

	private IBusiManager busiManager;

	private IConfigManager configManager;

	private CusDynaBean exeCommon(String appKey, CusDynaBean inputBean,
			boolean needCheck) {
		if (busiManager == null) {
			logger.error("busiManager需要业务系统的初始化，请确认");
			CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean(
					ExceptAll.project_nonull);
			return nullBean;
		}
		if (configManager == null) {
			logger.error("configManager需要业务系统的初始化，请确认");
			CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean(
					ExceptAll.project_nonull);
			return nullBean;
		}
		AbstractConfigClass conf = configManager.getConfig(appKey);
		CusDynaBean clientInfo = (CusDynaBean) inputBean
				.get(XMLNameSpace.ControlInfo);
		if (needCheck) {// 需要检查客户端
			if (clientInfo == null) {
				return conf.newOutBean(ExceptAll.conn_nocontrol);
			}
			// TODO 客户端较验
		}
		String msgId = clientInfo.getStrValueByName(Request.msgId,
				String.valueOf(new Date().getTime()));// 如果没有就生成一个
		CusDynaBean outBean = conf.newOutSuc(msgId);
		IBusiApp busiApp = busiManager.getBean(appKey);
		// inputBean检查
		Result paramcheck = inputBean.checkFields();
		if (!paramcheck.isSuc()) {
			outBean.setResult(paramcheck.getExcept());
			return outBean;
		}
		CusDynaBean retBean = busiApp.exe(inputBean, outBean);
		return retBean;
	}

	@Override
	public CusDynaBean exeNoCheck(String appKey, CusDynaBean inputBean) {
		return exeCommon(appKey, inputBean, false);
	}

	@Override
	public CusDynaBean exe(String appKey, CusDynaBean inputBean) {
		return exeCommon(appKey, inputBean, true);
	}

	/***
	 * 支持非Java的渠道接入，API由业务定义，因为它要加上注解等信息
	 * 
	 * @param appKey
	 * @param inputStr
	 * @return
	 */
	@Override
	public String exe(String appKey, String inputStr) {
		if (busiManager == null) {
			logger.error("busiManager需要业务系统的初始化，请确认");
			CusDynaBean nullBean = ConfigInstance.getInstance().getNullOutBean(
					ExceptAll.project_nonull);
			return nullBean.getJsonObj().toJSONString();
		}
		AbstractConfigClass conf = configManager.getConfig(appKey);
		CusDynaBean inputBean = conf.newInputBean();
		inputBean.setByJson(JSONObject.parseObject(inputStr));
		CusDynaBean retBean = this.exe(appKey, inputBean);
		return retBean.getJsonObj().toJSONString();
	}

	public IBusiManager getBusiManager() {
		return busiManager;
	}

	public void setBusiManager(IBusiManager busiManager) {
		this.busiManager = busiManager;
	}

	public IConfigManager getConfigManager() {
		return configManager;
	}

	public void setConfigManager(IConfigManager configManager) {
		this.configManager = configManager;
	}

}
