package net.wicp.tams.common.connector.beans.property;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSONObject;

@SuppressWarnings("rawtypes")
public class JavaBeanHandler extends BasicNoHandler {
	private static final long serialVersionUID = 1L;
	private final static Logger logger = LoggerFactory
			.getLogger(JavaBeanHandler.class);
	private Class beanClass;//

	public JavaBeanHandler(String name, Class type, Class contentType) {
		super(name, type, contentType);
		this.beanClass = contentType;
	}

	public JavaBeanHandler(String name, Class type) {
		super(name, type);
		this.beanClass = type;
	}

	@Override
	protected Result checkSingleValue(Object value) {
		if (value==null||value.getClass().isAssignableFrom(this.beanClass)) {
			return Result.getSuc();
		} else {
			logger.error("[{}]的类型不匹配，应该是[{}],但传进来的参数是[{}]基本类型", name,
					beanClass.getName(), value.getClass().getName());
			return new Result(ExceptAll.Param_typenofit);
		}
	}

	@Override
	public Object getSingleDefaultColValue() {
		String defaultValue = getAttriValue(ColProperty.defaultValue);
		if (StringUtils.isNotBlank(defaultValue)) {
			JSONObject json = JSONObject.parseObject(defaultValue);
			Object retdefaultobj = jsonTosingleObj(json);
			return retdefaultobj;
		} else {
			return null;
		}
	}

	@Override
	protected Object singleObjToJson(Object json) {
		String jsonstr = JSONObject.toJSONString(json);// java对象到json字
		return JSONObject.parse(jsonstr);
	}

	@Override
	protected Object jsonTosingleObj(Object obj) {
		// JSONObject inputobj = new JSONObject(String.valueOf(obj));
		JSONObject inputobj = (JSONObject) obj;
		@SuppressWarnings("unchecked")
		Object retobj = inputobj.toJavaObject(beanClass);
		return retobj;
	}

}
