package net.wicp.tams.common.connector;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.constant.param.Response;
import net.wicp.tams.common.exception.IExcept;

public abstract class BusiUtil {
	/**
	 * 设置返回值
	 * 
	 * @param outbean
	 *            返回bean
	 * @param error
	 *            错误信息
	 */
	public static void setResult(CusDynaBean outbean, IExcept error) {
		outbean.set(Response.errorCode, error.getErrorCode());
		outbean.set(Response.errorValue, error.getErrorValue());
		outbean.set(Response.errorDesc, error.getDesc());
		outbean.set(Response.errMsg, error.getErrMsg());
		outbean.set(Response.http, error.getHttp());
	}

	/***
	 * 结果返回json信息
	 * 
	 * @param result
	 * @return
	 */
	public static JSONObject setResult(Result result) {
		JSONObject retjson = new JSONObject();
		if (result.isSuc()) {
			retjson.put(Response.errorValue, 1000);
			retjson.put(Response.errorDesc, "OK");
			retjson.put(Response.errorCode, "no");
			retjson.put(Response.http, "200");
		} else {
			IExcept iExcept = result.getExcept();
			retjson.put(Response.errorValue, iExcept.getErrorValue());
			retjson.put(Response.errorDesc, iExcept.getErrMsg());
			retjson.put(Response.errorCode, iExcept.getErrorCode());
			retjson.put(Response.http, iExcept.getHttp());
		}
		return retjson;
	}

	/**
	 * 通过http得到httpstatus
	 * 
	 * @param http
	 * @return
	 */
	public static int getHttp(String http) {
		if (StringUtil.isNull(http)) {
			return 200;
		} else {
			return Integer.parseInt(http.split("\\.")[0]);
		}
	}

	public static int getHttp(IExcept error) {
		return getHttp(error.getHttp());
	}

}
