/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.connector.IClientCus;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.beans.CusDynaClass;
import net.wicp.tams.common.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.ConfigClassXml;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.connector.constant.param.Response;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.IExcept;
import net.wicp.tams.commons.exception.ProjectException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInstance {
    private static Logger logger = LoggerFactory.getLogger(ConfigInstance.class);
    private static volatile ConfigInstance INSTANCE;
    private static Object lockobj;
    private CusDynaClass inputClass = null;
    private CusDynaClass outClass = null;
    private AbstractConfigClass confNull = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConfigInstance getInstance() {
        if (INSTANCE == null) {
            Object object = lockobj;
            synchronized (object) {
                if (INSTANCE == null) {
                    ConfigInstance tempobj = new ConfigInstance();
                    InputStream clientInputStream = ConfigInstance.class.getResourceAsStream("/conf/ClientInfo.xml");
                    InputStream nullInputStream = ConfigInstance.class.getResourceAsStream("/conf/null.xml");
                    try {
                        ConfigClassXml conf = ConfigClassXml.createConfigClassXml("default.client", clientInputStream);
                        tempobj.inputClass = conf.parserInputNoCI();
                        tempobj.outClass = conf.parserOutNoCI();
                        String cusconf = Conf.get((String)"common.connector.dynabean.client.cus.conf");
                        if (tempobj.inputClass != null && StringUtils.isNotBlank((CharSequence)cusconf) && !"none".equals(cusconf)) {
                            try {
                                List<Map<ColProperty, String>> output;
                                IClientCus clientCus = (IClientCus)Class.forName(cusconf).newInstance();
                                List<Map<ColProperty, String>> input = clientCus.confClientInput();
                                if (CollectionUtils.isNotEmpty(input)) {
                                    tempobj.inputClass = conf.createNewClass(tempobj.inputClass, null, input);
                                }
                                if (CollectionUtils.isNotEmpty(output = clientCus.confClientOutput())) {
                                    tempobj.outClass = conf.createNewClass(tempobj.outClass, null, output);
                                }
                            }
                            catch (Exception e) {
                                logger.error("\u5ba2\u6237\u81ea\u5b9a\u4e49\u7684\u6a21\u677f\u9519\u8bef", (Throwable)e);
                            }
                        }
                        tempobj.confNull = ConfigClassXml.createConfigClassXml("default.null", nullInputStream);
                    }
                    catch (ProjectException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (clientInputStream != null) {
                                clientInputStream.close();
                            }
                            if (nullInputStream != null) {
                                nullInputStream.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error("\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                        }
                    }
                    INSTANCE = tempobj;
                }
            }
        }
        return INSTANCE;
    }

    public static void destroy() {
        AbstractConfigClass.clearCache();
        ConfigInstance.INSTANCE.inputClass = null;
        ConfigInstance.INSTANCE.outClass = null;
        ConfigInstance.INSTANCE.confNull = null;
        INSTANCE = null;
    }

    public CusDynaClass getInputClass() {
        return this.inputClass;
    }

    public CusDynaClass getOutClass() {
        return this.outClass;
    }

    public CusDynaBean newControlInfo(Properties inputobj) {
        AbstractDynaClassProperty[] props;
        CusDynaBean retbean = this.inputClass.newInstance();
        if (inputobj == null || inputobj.size() == 0) {
            return retbean;
        }
        for (AbstractDynaClassProperty prop : props = this.inputClass.getDynaProperties()) {
            String name = prop.getName();
            if (!inputobj.containsKey(name)) continue;
            retbean.set(name, inputobj.getProperty(name));
        }
        return retbean;
    }

    public CusDynaBean newControlInfo() {
        CusDynaBean retbean = this.inputClass.newInstance();
        retbean.set("senderSystem", Conf.get((String)"common.connector.dynabean.client.system"));
        retbean.set("senderApplication", Conf.get((String)"common.connector.dynabean.client.application"));
        retbean.set("senderChannel", Conf.get((String)"common.connector.dynabean.client.channel"));
        String version = Conf.get((String)"common.connector.dynabean.client.version");
        if (StringUtil.isNotNull((Object)version)) {
            retbean.set("version", version);
        }
        return retbean;
    }

    public CusDynaBean newControlInfo(Map<String, String> inputobj) {
        AbstractDynaClassProperty[] props;
        CusDynaBean retbean = this.inputClass.newInstance();
        if (MapUtils.isEmpty(inputobj)) {
            return retbean;
        }
        for (AbstractDynaClassProperty prop : props = this.inputClass.getDynaProperties()) {
            String name = prop.getName();
            if (!inputobj.containsKey(name)) continue;
            retbean.set(name, inputobj.get(name));
        }
        return retbean;
    }

    public static CusDynaBean getControlInfo(CusDynaBean inputBean) {
        return (CusDynaBean)((Object)inputBean.get("ControlInfo"));
    }

    private CusDynaBean newRespInfo(String msgId, String receiptSystem, String receiptApplication) {
        CusDynaBean nullbean = this.outClass.newInstance().newCusDynaBean(Response.respInfo.toString());
        nullbean.set("msgId", msgId);
        if (StringUtils.isBlank((CharSequence)msgId)) {
            nullbean.set("msgIdResp", String.valueOf(new Date().getTime()));
        } else {
            nullbean.set("msgIdResp", msgId);
        }
        nullbean.set("receiptSystem", receiptSystem);
        nullbean.set("receiptApplication", receiptApplication);
        return nullbean;
    }

    public CusDynaBean newRespInfo(String msgId) {
        return this.newRespInfo(msgId, Conf.get((String)"common.connector.dynabean.client.system"), Conf.get((String)"common.connector.dynabean.client.application"));
    }

    public CusDynaBean newRespInfo() {
        return this.newRespInfo(null, Conf.get((String)"common.connector.dynabean.client.system"), Conf.get((String)"common.connector.dynabean.client.application"));
    }

    public CusDynaBean getNullOutBean(IExcept except) {
        return this.confNull.newOutBean(except);
    }

    static {
        lockobj = new Object();
    }
}

