package net.wicp.tams.common.connector;

import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.constant.param.Response;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.IExcept;

public abstract class BusiUtil {
	/**
	 * 设置返回值
	 * 
	 * @param outbean
	 *            返回bean
	 * @param error
	 *            错误信息
	 */
	public static void setError(CusDynaBean outbean, IExcept error) {
		outbean.set(Response.errorCode, error.getErrorCode());
		outbean.set(Response.errorValue, error.getErrorValue());
		outbean.set(Response.errorDesc, error.getDesc());
		outbean.set(Response.errMsg, error.getErrMsg());
		outbean.set(Response.http, error.getHttp());
	}

	/**
	 * 通过http得到httpstatus
	 * 
	 * @param http
	 * @return
	 */
	public static int getHttp(String http) {
		if (StringUtil.isNull(http)) {
			return 200;
		} else {
			return Integer.parseInt(http.split("\\.")[0]);
		}
	}

	public static int getHttp(IExcept error) {
		return getHttp(error.getHttp());
	}

}
