/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.IExcept;
import net.wicp.tams.commons.exception.ProjectException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlUtil {
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public static synchronized XMLReader getXMLReader() {
        try {
            SAXParser parser = saxFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            return parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException se) {
            return null;
        }
    }

    public static final Document parserDocment(String src) throws ProjectException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(src)));
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u89e3\u6790XML\u6587\u6863\u9519\u8bef");
        }
    }

    public static Element getElementByTagName(Document doc, String tagName) {
        NodeList nodes = doc.getElementsByTagName(tagName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static final String findValueByAttrName(ConfigurationNode node, String attrName) {
        List typeAry = node.getAttributes(attrName);
        if (CollectionUtils.isEmpty((Collection)typeAry)) {
            return null;
        }
        return String.valueOf(((DefaultConfigurationNode)typeAry.get(0)).getValue());
    }

    public static String getElementValue(Element element) {
        if (element.hasChildNodes()) {
            return element.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static final ConfigurationNode getFirstNodeByNodeName(ConfigurationNode node, String name) {
        List nodes = node.getChildren(name);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return null;
        }
        return (ConfigurationNode)nodes.get(0);
    }

    public static Object getValueByXpath(Object beanObj, String xpath) {
        JXPathContext context = JXPathContext.newContext((Object)beanObj);
        return context.getValue(xpath);
    }

    public static List<String> getChildValues(ConfigurationNode superNode, String subNodeName) {
        ArrayList<String> retlist = new ArrayList<String>();
        List includeList = superNode.getChildren(subNodeName);
        if (CollectionUtils.isEmpty((Collection)includeList)) {
            return retlist;
        }
        for (ConfigurationNode configurationNode : includeList) {
            retlist.add(String.valueOf(configurationNode.getValue()));
        }
        return retlist;
    }

    public static void mergexml(XMLConfiguration xml, String path, String addStr) throws ConfigurationException {
        ByteArrayInputStream addStrIn = new ByteArrayInputStream(addStr.getBytes());
        XMLConfiguration addConfig = new XMLConfiguration();
        addConfig.load((InputStream)addStrIn);
        int startint = StringUtil.isNotNull((Object)path) ? path.lastIndexOf(".") : -1;
        String key = path.substring(startint + 1);
        xml.addNodes(key, (Collection)addConfig.getRoot().getChildren());
    }

    static {
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
    }
}

