package net.wicp.tams.common.connector.executor.busi;

import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.ConfigClassXml;
import net.wicp.tams.common.connector.executor.impl.AbsConfigManager;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.ProjectException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/****
 * 由key决定调用的配置信息，这样就不需要service.properties文件了 appKey 为 a.b.c 将转为路径 a/b/c
 * 
 * @author zhoujunhui
 *
 */
@SuppressWarnings("rawtypes")
public class KeyConfigManager extends AbsConfigManager {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	private Class classz;

	public KeyConfigManager(String dir) {
		super(dir);
	}

	public KeyConfigManager() {
		super();
	}

	public KeyConfigManager(Class classz) {
		this.classz = classz;
	}

	@Override
	protected AbstractConfigClass createConfig(String appKey) {
		String xmlValue = appKey.replaceAll("\\.", "/") + ".xml";
		try {
			String path = StringUtil.isNull(dir) ? xmlValue : IOUtil.mergeFolderAndFilePath(dir, xmlValue);
			AbstractConfigClass retobj = ConfigClassXml.createConfigClassXml(appKey,
					IOUtil.fileToInputStream(path, classz));
			return retobj;
		} catch (ProjectException e) {
			logger.error("------加载" + appKey + "对应的xml错误------", e);
			throw new IllegalArgumentException("------加载" + appKey + "对应的xml错误------");
		}
	}

}
