/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.config.xmlParser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.connector.XmlUtil;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.XMLConfigurationExt;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.connector.constant.ColType;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.IExcept;
import net.wicp.tams.commons.exception.ProjectException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang3.StringUtils;

public class ConfigClassXml
extends AbstractConfigClass {
    private XMLConfigurationExt xml;

    private ConfigClassXml(String className, String path, String xmlName) throws ProjectException {
        super(className);
        File inputFile = new File(path, xmlName);
        try {
            FileReader reader = new FileReader(inputFile);
            this.xml = new XMLConfigurationExt();
            this.xml.setEncoding("UTF-8");
            this.xml.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
            this.xml.load(reader);
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u52a0\u8f7dXML\u6587\u4ef6\u9519\u8bef");
        }
        AbstractConfigClass.parseClassMap.put(className, this);
    }

    private ConfigClassXml(String className, InputStream stream) throws ProjectException {
        super(className);
        try {
            this.xml = new XMLConfigurationExt();
            this.xml.setEncoding("UTF-8");
            this.xml.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
            this.xml.load(stream);
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "xml\u6d41\u7ec4\u88c5\u6210XML\u9519\u8bef");
        }
        AbstractConfigClass.parseClassMap.put(className, this);
    }

    public static ConfigClassXml createConfigClassXml(String className, String path, String xmlName) throws ProjectException {
        AbstractConfigClass retobj = AbstractConfigClass.parseClassMap.get(className);
        if (retobj == null) {
            retobj = new ConfigClassXml(className, path, xmlName);
            AbstractConfigClass.parseClassMap.put(className, retobj);
        }
        return (ConfigClassXml)retobj;
    }

    public static ConfigClassXml createConfigClassXml(String className, InputStream stream) throws ProjectException {
        AbstractConfigClass retobj = AbstractConfigClass.parseClassMap.get(className);
        if (retobj == null) {
            retobj = new ConfigClassXml(className, stream);
            AbstractConfigClass.parseClassMap.put(className, retobj);
        }
        return (ConfigClassXml)retobj;
    }

    private List<Map<ColProperty, String>> retXmlMap(ConfigurationNode node) {
        List nodeList = node.getChildren();
        ArrayList<Map<ColProperty, String>> retObj = null;
        if (CollectionUtils.isNotEmpty((Collection)nodeList)) {
            retObj = new ArrayList<Map<ColProperty, String>>();
            for (ConfigurationNode tempNode : nodeList) {
                retObj.add(ConfigClassXml.packAttributesFromXml(tempNode));
            }
        }
        return retObj;
    }

    @Override
    public List<Map<ColProperty, String>> createColPropertyByRoot(String nodeName) {
        if (this.xml == null) {
            return null;
        }
        ConfigurationNode node = XmlUtil.getFirstNodeByNodeName((ConfigurationNode)this.xml.getRoot(), nodeName);
        return this.retXmlMap(node);
    }

    @Override
    public List<Map<ColProperty, String>> createColPropertyByPath(String nodePath) {
        if (this.xml == null) {
            return null;
        }
        ConfigurationNode node = this.getFirstNodesByPath(nodePath);
        return this.retXmlMap(node);
    }

    public List<ConfigurationNode> getNodesByPath(String path) {
        List<ConfigurationNode> nodes = this.xml.fetchNodeList(path);
        return nodes;
    }

    public ConfigurationNode getFirstNodesByPath(String path) {
        List<ConfigurationNode> nodes = this.getNodesByPath(path);
        if (CollectionUtils.isNotEmpty(nodes)) {
            return nodes.iterator().next();
        }
        return null;
    }

    private static final String findValueByAttrName(ConfigurationNode node, ColProperty colProperty) {
        List typeAry = node.getAttributes(colProperty.name());
        if (CollectionUtils.isEmpty((Collection)typeAry)) {
            return null;
        }
        return String.valueOf(((DefaultConfigurationNode)typeAry.get(0)).getValue());
    }

    private static final Map<ColProperty, String> packAttributesFromXml(ConfigurationNode pnode) {
        HashMap<ColProperty, String> attributes = new HashMap<ColProperty, String>();
        for (ColProperty colProperty : ColProperty.values()) {
            String tempValue;
            if (colProperty.equals((Object)ColProperty.xpath) || !StringUtils.isNotBlank((CharSequence)(tempValue = ConfigClassXml.findValueByAttrName(pnode, colProperty)))) continue;
            attributes.put(colProperty, tempValue);
        }
        ColType colType = ColType.getByName((String)attributes.get((Object)ColProperty.type));
        if (colType != null && colType.isNeedXPath()) {
            String xpath = ConfigClassXml.getXPath(pnode);
            attributes.put(ColProperty.xpath, xpath);
        }
        return attributes;
    }

    private static String getNodeName(ConfigurationNode node) {
        if ("COL".equals(node.getName())) {
            return ConfigClassXml.findValueByAttrName(node, ColProperty.name);
        }
        return node.getName();
    }

    public static String getXPath(ConfigurationNode node) {
        if (node == null || node.getParentNode() == null) {
            return null;
        }
        StringBuffer retBuf = new StringBuffer();
        ConfigClassXml.upXPath(node, retBuf);
        return retBuf.toString();
    }

    private static void upXPath(ConfigurationNode node, StringBuffer addPath) {
        if (node == null) {
            return;
        }
        if ("COL".equals(node.getName())) {
            addPath.insert(0, "/COL[@name = '" + ConfigClassXml.getNodeName(node) + "']");
        } else {
            addPath.insert(0, ConfigClassXml.getNodeName(node));
        }
        ConfigurationNode parentNode = node.getParentNode();
        if (parentNode != null && !"InterFaceMapping".equals(parentNode.getName())) {
            ConfigClassXml.upXPath(parentNode, addPath);
        }
    }
}

