/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.executor.busi;

import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Properties;
import net.wicp.tams.common.connector.config.AbstractConfigClass;
import net.wicp.tams.common.connector.config.xmlParser.ConfigClassXml;
import net.wicp.tams.common.connector.executor.impl.AbsConfigManager;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.ProjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigManager
extends AbsConfigManager {
    public static final Properties serviceProp = new Properties();
    private static final Logger logger = LoggerFactory.getLogger(FileConfigManager.class);

    public FileConfigManager(String dir) {
        super(dir);
    }

    public FileConfigManager() {
    }

    @Override
    protected AbstractConfigClass createConfig(String appKey) {
        String xmlValue = serviceProp.getProperty(String.format("%s.%s", appKey, "xml"));
        try {
            String path = StringUtil.isNull((Object)this.dir) ? xmlValue : IOUtil.mergeFolderAndFilePath((String)this.dir, (String)xmlValue);
            ConfigClassXml retobj = ConfigClassXml.createConfigClassXml(appKey, IOUtil.fileToInputStream((String)path, null));
            return retobj;
        }
        catch (ProjectException e) {
            logger.error("------\u52a0\u8f7d" + appKey + "\u5bf9\u5e94\u7684xml\u9519\u8bef------", (Throwable)e);
            throw new IllegalArgumentException("------\u52a0\u8f7d" + appKey + "\u5bf9\u5e94\u7684xml\u9519\u8bef------");
        }
    }

    static {
        try {
            URL jarurl = Thread.currentThread().getContextClassLoader().getResource("/service.properties");
            if (jarurl == null) {
                jarurl = Thread.currentThread().getContextClassLoader().getResource("service.properties");
            }
            String url = jarurl.getPath();
            serviceProp.load(new FileReader(new File(url)));
        }
        catch (Exception e) {
            logger.error("------\u6ca1\u6709\u83b7\u5f97\u670d\u52a1\u5b9a\u4e49\u6587\u4ef6service.properties------", (Throwable)e);
        }
    }
}

