/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import net.wicp.tams.common.connector.beans.property.BasicHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.IExcept;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerHandler
extends BasicHandler {
    private static final long serialVersionUID = 946199084482013912L;
    private static final Logger logger = LoggerFactory.getLogger(IntegerHandler.class);

    public IntegerHandler(String name) {
        super(name);
    }

    public IntegerHandler(String name, Class type) {
        super(name, type);
    }

    public IntegerHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value != null && !(value instanceof Integer)) {
            logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fInteger,\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u7c7b\u578b", (Object)this.name, (Object)value.getClass().getName());
            return new Result((IExcept)ExceptAll.Param_typenofit);
        }
        if (!this.isNull() && value == null || StringUtils.isBlank((CharSequence)StringUtil.hasNull((String[])new String[]{String.valueOf(value)}))) {
            logger.error("[{}]\u4e0d\u5141\u8bb8\u4f20\u7a7a\u503c", (Object)this.name);
            return new Result((IExcept)ExceptAll.project_nonull);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAttriValue(ColProperty.min)) && Integer.parseInt(this.getAttriValue(ColProperty.min)) > (Integer)value) {
            logger.error("[{}]\u6bd4\u6700\u5c0f\u503c[{}]\u8fd8\u5c0f", (Object)this.name, (Object)this.getAttriValue(ColProperty.min));
            return new Result((IExcept)ExceptAll.project_overflow);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAttriValue(ColProperty.max)) && Integer.parseInt(this.getAttriValue(ColProperty.max)) < (Integer)value) {
            logger.error("[{}]\u6bd4\u6700\u5927\u503c[{}]\u8fd8\u5927", (Object)this.name, (Object)this.getAttriValue(ColProperty.max));
            return new Result((IExcept)ExceptAll.project_overflow);
        }
        return Result.getSuc();
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            return null;
        }
        return Integer.parseInt(defaultValue);
    }

    @Override
    protected Object singleObjToJson(Object json) {
        return String.valueOf(json);
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        return new Integer(String.valueOf(obj));
    }
}

