package net.wicp.tams.common.connector.executor.impl;

import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.busi.SpringBusiManager;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/***
 * KeyConfigManager 和 SpringBusiManager组合的executor，可以消除service.properties文件
 * 添加bean: bean id="SpringInit" class="net.wicp.tams.commons.connector.executor.impl.SpringInit"
 * 
 * @author zhoujunhui
 *
 */
public class SpringInit implements ApplicationContextAware {
	private IConfigManager configManager;
	private CommonService executor;
	private ApplicationContext applicationContext;

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
		IBusiManager busi = new SpringBusiManager(applicationContext);
		configManager = new KeyConfigManager();
		executor = new CommonService();
		executor.setBusiManager(busi);
		executor.setConfigManager(configManager);
	}

	public IConfigManager getConfigManager() {
		return configManager;
	}

	public void setConfigManager(IConfigManager configManager) {
		this.configManager = configManager;
	}

	public CommonService getExecutor() {
		return executor;
	}

	public void setExecutor(CommonService executor) {
		this.executor = executor;
	}

	public ApplicationContext getApplicationContext() {
		return applicationContext;
	}

}
