/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.cassandra.typecodec;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.util.Date;

public class DateCodec
extends TypeCodec<Date> {
    private final TypeCodec<LocalDate> innerCodec;

    public DateCodec(TypeCodec<LocalDate> codec, Class<Date> javaClass) {
        super(codec.getCqlType(), javaClass);
        this.innerCodec = codec;
    }

    public ByteBuffer serialize(Date value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return this.innerCodec.serialize((Object)LocalDate.fromMillisSinceEpoch((long)value.getTime()), protocolVersion);
    }

    public Date deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return new Date(((LocalDate)this.innerCodec.deserialize(bytes, protocolVersion)).getMillisSinceEpoch());
    }

    public Date parse(String value) throws InvalidTypeException {
        return new Date(((LocalDate)this.innerCodec.parse(value)).getMillisSinceEpoch());
    }

    public String format(Date value) throws InvalidTypeException {
        return value.toString();
    }
}

