/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.cassandra;

import net.wicp.tams.common.apiext.StringUtil;

/**
 * ################## 常用字段类型 ########################## int 32位整数 int bigint
 * 64整数 long float 32位浮点数 flaot counter 计数器,支持原子性增减,不能直接赋值 long double 64位浮点数
 * double boolean 布尔 boolean decimal 高精度小数 BigDecimal list 列表 List set 集合 Set
 * map 键值对 map text utf8编码的字符串 String varchar 与text一样 timestamp 日期 Date
 * ############################################################
 **/

public enum CassandrType {
	ascii("ascii", "ASCII字符串"),

	bigint("bigint", "64位有符号长"),

	blob("blob", "任意字节"),

	boolean_("boolean", "true或false"),

	counter("counter", "计数器列"),

	decimal("decimal", "变量精度十进制"),

	double_("double", "64位IEEE-754浮点"),

	float_("float", "32位IEEE-754浮点"),

	inet("inet", "一个IP地址，IPv4或IPv6"),

	int_("int", "32位有符号整数"),

	text("text", "UTF8编码的字符串"),

	timestamp("timestamp", "时间戳"),

	timeuuid("timeuuid", "类型1 UUID"),

	uuid("uuid", "类型1或类型4"),

	varchar("varchar", "uTF8编码的字符串"),

	varint("varint", "任意精度整数");

	private final String desc;

	private final String value;

	public String getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

	private CassandrType(String value, String desc) {
		this.desc = desc;
		this.value = value;
	}

	public static String formatValue(CassandrType cassandrType, String value) {
		String retValue = value;
		switch (cassandrType) {
		case text:
			retValue = "'" + value + "'";
			break;
		default:
			break;
		}
		return retValue;
	}

	public static CassandrType get(String value) {
		if (StringUtil.isNull(value)) {
			return CassandrType.text;
		}
		for (CassandrType ele : CassandrType.values()) {
			if (ele.getValue().equals(value)) {
				return ele;
			}
		}
		return CassandrType.text;
	}

}
