/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.cassandra.CassandrType;
import net.wicp.tams.common.cassandra.bean.Columns;
import net.wicp.tams.common.cassandra.jdbc.CassandraData;
import net.wicp.tams.common.cassandra.jdbc.CassandraDatas;
import net.wicp.tams.common.cassandra.jdbc.OptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CassandraAssit {
    private static final Logger log = LoggerFactory.getLogger(CassandraAssit.class);
    private static final Map<String, Cluster> instmap = new HashMap<String, Cluster>();
    private static final Map<String, Session> sessionmap = new HashMap<String, Session>();
    private static final Map<String, MappingManager> mappingManagermap = new HashMap<String, MappingManager>();

    public static void shutdown() {
        for (String poolname : instmap.keySet()) {
            instmap.get(poolname).close();
        }
        instmap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Cluster getCluster(String name) {
        if (instmap.get(name) != null) return instmap.get(name);
        Class<CassandraAssit> clazz = CassandraAssit.class;
        synchronized (CassandraAssit.class) {
            if (instmap.get(name) != null) return instmap.get(name);
            Properties props = Conf.getPreToProp((String)"common.cassandra.pool.default", (boolean)true);
            if (!"default".equals(name)) {
                Map map = Conf.getPre((String)("common.cassandra.pool." + name), (boolean)true);
                for (String key : map.keySet()) {
                    props.put(key, map.get(key));
                }
            }
            Conf.overProp((Properties)props);
            Cluster cluster = CassandraAssit.initCluster(props);
            instmap.put(name, cluster);
            Session session = cluster.connect();
            sessionmap.put(name, session);
            mappingManagermap.put(name, new MappingManager(session));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instmap.get(name);
        }
    }

    public static void optDatas(CassandraDatas datas) {
        if (datas == null || datas.getDatasCount() == 0) {
            return;
        }
        for (CassandraData data : datas.getDatasList()) {
            switch (data.getOptType()) {
                case insert: 
                case delete: {
                    String delsql = String.format("DELETE FROM  %s.%s WHERE %s=%s;", datas.getKs(), datas.getTb(), datas.getKey(), CassandrType.formatValue(CassandrType.get(datas.getTypeOrDefault(datas.getKey(), "text")), data.getValueMap().get(datas.getKey())));
                    ResultSet rs = CassandraAssit.getSession().execute(delsql);
                    System.out.println("rs=" + rs);
                    if (data.getOptType() == OptType.delete) break;
                }
                case update: {
                    Set<String> valueKeys = data.getValueMap().keySet();
                    Object[] cols = new String[valueKeys.size()];
                    Object[] values = new String[valueKeys.size()];
                    int i = 0;
                    for (String col : valueKeys) {
                        int j = i++;
                        cols[j] = col;
                        values[j] = CassandrType.formatValue(CassandrType.get(datas.getTypeOrDefault(col, "text")), data.getValueMap().get(col));
                    }
                    String sql = String.format("INSERT INTO %s.%s (%s) VALUES (%s);", datas.getKs(), datas.getTb(), CollectionUtil.arrayJoin((Object[])cols, (String)","), CollectionUtil.arrayJoin((Object[])values, (String)","));
                    ResultSet rs2 = CassandraAssit.getSession().execute(sql);
                    System.out.println("rs=" + rs2);
                }
            }
        }
    }

    public static List<Columns> queryCols(String ks, String table) {
        String sql = String.format("select * from system_schema.columns where  keyspace_name='%s' and table_name='%s';", ks, table);
        ResultSet rs = CassandraAssit.getSession().execute(sql);
        Result map = CassandraAssit.getMappingManager().mapper(Columns.class).map(rs);
        return map.all();
    }

    public static void addCols(String ks, String table, Map<String, String> addCols) {
        for (String key : addCols.keySet()) {
            String sql = String.format("alter table %s.%s add %s %s;", ks, table, key, addCols.get(key));
            ResultSet resultSet = CassandraAssit.getSession().execute(sql);
        }
    }

    public static Session getSessionNoConf(String name, Properties props) {
        if (sessionmap.containsKey(name)) {
            log.warn("\u5df2\u5b58\u5728\u6b64\u914d\u7f6e,\u53ef\u4ee5\u8c03\u7528getDataSource\u62ff\u5230\u6570\u636e\u6e90");
            return sessionmap.get(name);
        }
        Properties propsDefault = Conf.getPreToProp((String)"common.jdbc.datasource.default", (boolean)true);
        for (Object key : props.keySet()) {
            propsDefault.put(String.valueOf(key), props.get(key));
        }
        Properties overprops = new Properties();
        for (Object keyobj : propsDefault.keySet()) {
            overprops.put(String.format("common.jdbc.datasource.%s.%s", name, keyobj), propsDefault.get(keyobj));
        }
        Conf.overProp((Properties)overprops);
        CassandraAssit.getCluster(name);
        return sessionmap.get(name);
    }

    public static boolean existSession(String name) {
        return sessionmap.containsKey(name);
    }

    public static final Session getSession() {
        CassandraAssit.getCluster("default");
        return sessionmap.get("default");
    }

    public static Session getSession(String name) {
        CassandraAssit.getCluster(name);
        return sessionmap.get(name);
    }

    public static final MappingManager getMappingManager(String name) {
        CassandraAssit.getCluster(name);
        return mappingManagermap.get(name);
    }

    public static final MappingManager getMappingManager() {
        return CassandraAssit.getMappingManager("default");
    }

    private static Cluster initCluster(Properties props) {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setConsistencyLevel(ConsistencyLevel.valueOf((String)props.getProperty("query.consistencyLevel")));
        queryOptions.setFetchSize(Integer.parseInt(props.getProperty("query.fetchSize")));
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setMaxRequestsPerConnection(HostDistance.LOCAL, Integer.parseInt(props.getProperty("pooling.maxRequestsPerConnection")));
        poolingOptions.setConnectionsPerHost(HostDistance.LOCAL, Integer.parseInt(props.getProperty("pooling.coreConnectionsPerHost")), Integer.parseInt(props.getProperty("pooling.maxConnectionsPerHost")));
        Cluster cluster = Cluster.builder().addContactPoint(props.getProperty("contactpoint")).withPoolingOptions(poolingOptions).withPort(Integer.parseInt(props.getProperty("port"))).withQueryOptions(queryOptions).build();
        return cluster;
    }
}

