/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.cassandra;

import net.wicp.tams.common.apiext.StringUtil;

public enum CassandrType {
    ascii("ascii", "ASCII\u5b57\u7b26\u4e32"),
    bigint("bigint", "64\u4f4d\u6709\u7b26\u53f7\u957f"),
    blob("blob", "\u4efb\u610f\u5b57\u8282"),
    boolean_("boolean", "true\u6216false"),
    counter("counter", "\u8ba1\u6570\u5668\u5217"),
    decimal("decimal", "\u53d8\u91cf\u7cbe\u5ea6\u5341\u8fdb\u5236"),
    double_("double", "64\u4f4dIEEE-754\u6d6e\u70b9"),
    float_("float", "32\u4f4dIEEE-754\u6d6e\u70b9"),
    inet("inet", "\u4e00\u4e2aIP\u5730\u5740\uff0cIPv4\u6216IPv6"),
    int_("int", "32\u4f4d\u6709\u7b26\u53f7\u6574\u6570"),
    text("text", "UTF8\u7f16\u7801\u7684\u5b57\u7b26\u4e32"),
    timestamp("timestamp", "\u65f6\u95f4\u6233"),
    timeuuid("timeuuid", "\u7c7b\u578b1 UUID"),
    uuid("uuid", "\u7c7b\u578b1\u6216\u7c7b\u578b4"),
    varchar("varchar", "uTF8\u7f16\u7801\u7684\u5b57\u7b26\u4e32"),
    varint("varint", "\u4efb\u610f\u7cbe\u5ea6\u6574\u6570");

    private final String desc;
    private final String value;

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private CassandrType(String value, String desc) {
        this.desc = desc;
        this.value = value;
    }

    public static String formatValue(CassandrType cassandrType, String value) {
        String retValue = value;
        switch (cassandrType) {
            case text: {
                retValue = "'" + value + "'";
                break;
            }
        }
        return retValue;
    }

    public static CassandrType get(String value) {
        if (StringUtil.isNull((Object)value)) {
            return text;
        }
        for (CassandrType ele : CassandrType.values()) {
            if (!ele.getValue().equals(value)) continue;
            return ele;
        }
        return text;
    }
}

