/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import java.util.BitSet;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public final class TableMapLogEvent
extends LogEvent {
    protected final String dbname;
    protected final String tblname;
    protected final int columnCnt;
    protected final ColumnInfo[] columnInfo;
    protected final long tableId;
    protected BitSet nullBits;
    public static final int TM_MAPID_OFFSET = 0;
    public static final int TM_FLAGS_OFFSET = 6;

    public TableMapLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        buffer.position(commonHeaderLen + 0);
        this.tableId = postHeaderLen == 6 ? buffer.getUint32() : buffer.getUlong48();
        buffer.position(commonHeaderLen + postHeaderLen);
        this.dbname = buffer.getString();
        buffer.forward(1);
        this.tblname = buffer.getString();
        buffer.forward(1);
        this.columnCnt = (int)buffer.getPackedLong();
        this.columnInfo = new ColumnInfo[this.columnCnt];
        for (int i = 0; i < this.columnCnt; ++i) {
            ColumnInfo info = new ColumnInfo();
            info.type = buffer.getUint8();
            this.columnInfo[i] = info;
        }
        if (buffer.position() < buffer.limit()) {
            int fieldSize = (int)buffer.getPackedLong();
            this.decodeFields(buffer, fieldSize);
            this.nullBits = buffer.getBitmap(this.columnCnt);
        }
    }

    private final void decodeFields(LogBuffer buffer, int len) {
        int limit = buffer.limit();
        buffer.limit(len + buffer.position());
        block9: for (int i = 0; i < this.columnCnt; ++i) {
            ColumnInfo info = this.columnInfo[i];
            switch (info.type) {
                case 4: 
                case 5: 
                case 245: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 255: {
                    info.meta = buffer.getUint8();
                    continue block9;
                }
                case 247: 
                case 248: {
                    logger.warn("This enumeration value is only used internally and cannot exist in a binlog: type=" + info.type);
                    continue block9;
                }
                case 254: {
                    int x = buffer.getUint8() << 8;
                    info.meta = x += buffer.getUint8();
                    continue block9;
                }
                case 16: {
                    info.meta = buffer.getUint16();
                    continue block9;
                }
                case 15: {
                    info.meta = buffer.getUint16();
                    continue block9;
                }
                case 246: {
                    int x = buffer.getUint8() << 8;
                    info.meta = x += buffer.getUint8();
                    continue block9;
                }
                case 17: 
                case 18: 
                case 19: {
                    info.meta = buffer.getUint8();
                    continue block9;
                }
                default: {
                    info.meta = 0;
                }
            }
        }
        buffer.limit(limit);
    }

    public final String getDbName() {
        return this.dbname;
    }

    public final String getTableName() {
        return this.tblname;
    }

    public final int getColumnCnt() {
        return this.columnCnt;
    }

    public final ColumnInfo[] getColumnInfo() {
        return this.columnInfo;
    }

    public final long getTableId() {
        return this.tableId;
    }

    public static final class ColumnInfo {
        public int type;
        public int meta;
    }
}

