/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser;

import net.wicp.tams.common.binlog.parser.event.LogHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogEvent {
    public static final int BINLOG_VERSION = 4;
    public static final String SERVER_VERSION = "5.0";
    public static final int EVENT_TYPE_OFFSET = 4;
    public static final int SERVER_ID_OFFSET = 5;
    public static final int EVENT_LEN_OFFSET = 9;
    public static final int LOG_POS_OFFSET = 13;
    public static final int FLAGS_OFFSET = 17;
    public static final int QUERY_HEADER_MINIMAL_LEN = 11;
    public static final int QUERY_HEADER_LEN = 13;
    public static final int UNKNOWN_EVENT = 0;
    public static final int START_EVENT_V3 = 1;
    public static final int QUERY_EVENT = 2;
    public static final int STOP_EVENT = 3;
    public static final int ROTATE_EVENT = 4;
    public static final int INTVAR_EVENT = 5;
    public static final int LOAD_EVENT = 6;
    public static final int SLAVE_EVENT = 7;
    public static final int CREATE_FILE_EVENT = 8;
    public static final int APPEND_BLOCK_EVENT = 9;
    public static final int EXEC_LOAD_EVENT = 10;
    public static final int DELETE_FILE_EVENT = 11;
    public static final int NEW_LOAD_EVENT = 12;
    public static final int RAND_EVENT = 13;
    public static final int USER_VAR_EVENT = 14;
    public static final int FORMAT_DESCRIPTION_EVENT = 15;
    public static final int XID_EVENT = 16;
    public static final int BEGIN_LOAD_QUERY_EVENT = 17;
    public static final int EXECUTE_LOAD_QUERY_EVENT = 18;
    public static final int TABLE_MAP_EVENT = 19;
    public static final int PRE_GA_WRITE_ROWS_EVENT = 20;
    public static final int PRE_GA_UPDATE_ROWS_EVENT = 21;
    public static final int PRE_GA_DELETE_ROWS_EVENT = 22;
    public static final int WRITE_ROWS_EVENT_V1 = 23;
    public static final int UPDATE_ROWS_EVENT_V1 = 24;
    public static final int DELETE_ROWS_EVENT_V1 = 25;
    public static final int INCIDENT_EVENT = 26;
    public static final int HEARTBEAT_LOG_EVENT = 27;
    public static final int IGNORABLE_LOG_EVENT = 28;
    public static final int ROWS_QUERY_LOG_EVENT = 29;
    public static final int WRITE_ROWS_EVENT = 30;
    public static final int UPDATE_ROWS_EVENT = 31;
    public static final int DELETE_ROWS_EVENT = 32;
    public static final int GTID_LOG_EVENT = 33;
    public static final int ANONYMOUS_GTID_LOG_EVENT = 34;
    public static final int PREVIOUS_GTIDS_LOG_EVENT = 35;
    public static final int MYSQL_EVENTS_END = 36;
    public static final int MARIA_EVENTS_BEGIN = 160;
    public static final int ANNOTATE_ROWS_EVENT = 160;
    public static final int BINLOG_CHECKPOINT_EVENT = 161;
    public static final int GTID_EVENT = 162;
    public static final int GTID_LIST_EVENT = 163;
    public static final int ENUM_END_EVENT = 164;
    public static final int EXTRA_ROW_INFO_LEN_OFFSET = 0;
    public static final int EXTRA_ROW_INFO_FORMAT_OFFSET = 1;
    public static final int EXTRA_ROW_INFO_HDR_BYTES = 2;
    public static final int EXTRA_ROW_INFO_MAX_PAYLOAD = 253;
    public static final int BINLOG_CHECKSUM_ALG_OFF = 0;
    public static final int BINLOG_CHECKSUM_ALG_CRC32 = 1;
    public static final int BINLOG_CHECKSUM_ALG_ENUM_END = 2;
    public static final int BINLOG_CHECKSUM_ALG_UNDEF = 255;
    public static final int CHECKSUM_CRC32_SIGNATURE_LEN = 4;
    public static final int BINLOG_CHECKSUM_ALG_DESC_LEN = 1;
    public static final int BINLOG_CHECKSUM_LEN = 4;
    public static final int MARIA_SLAVE_CAPABILITY_UNKNOWN = 0;
    public static final int MARIA_SLAVE_CAPABILITY_ANNOTATE = 1;
    public static final int MARIA_SLAVE_CAPABILITY_TOLERATE_HOLES = 2;
    public static final int MARIA_SLAVE_CAPABILITY_BINLOG_CHECKPOINT = 3;
    public static final int MARIA_SLAVE_CAPABILITY_GTID = 4;
    public static final int MARIA_SLAVE_CAPABILITY_MINE = 4;
    public static final int LOG_EVENT_IGNORABLE_F = 128;
    public static final int MYSQL_TYPE_DECIMAL = 0;
    public static final int MYSQL_TYPE_TINY = 1;
    public static final int MYSQL_TYPE_SHORT = 2;
    public static final int MYSQL_TYPE_LONG = 3;
    public static final int MYSQL_TYPE_FLOAT = 4;
    public static final int MYSQL_TYPE_DOUBLE = 5;
    public static final int MYSQL_TYPE_NULL = 6;
    public static final int MYSQL_TYPE_TIMESTAMP = 7;
    public static final int MYSQL_TYPE_LONGLONG = 8;
    public static final int MYSQL_TYPE_INT24 = 9;
    public static final int MYSQL_TYPE_DATE = 10;
    public static final int MYSQL_TYPE_TIME = 11;
    public static final int MYSQL_TYPE_DATETIME = 12;
    public static final int MYSQL_TYPE_YEAR = 13;
    public static final int MYSQL_TYPE_NEWDATE = 14;
    public static final int MYSQL_TYPE_VARCHAR = 15;
    public static final int MYSQL_TYPE_BIT = 16;
    public static final int MYSQL_TYPE_TIMESTAMP2 = 17;
    public static final int MYSQL_TYPE_DATETIME2 = 18;
    public static final int MYSQL_TYPE_TIME2 = 19;
    public static final int MYSQL_TYPE_JSON = 245;
    public static final int MYSQL_TYPE_NEWDECIMAL = 246;
    public static final int MYSQL_TYPE_ENUM = 247;
    public static final int MYSQL_TYPE_SET = 248;
    public static final int MYSQL_TYPE_TINY_BLOB = 249;
    public static final int MYSQL_TYPE_MEDIUM_BLOB = 250;
    public static final int MYSQL_TYPE_LONG_BLOB = 251;
    public static final int MYSQL_TYPE_BLOB = 252;
    public static final int MYSQL_TYPE_VAR_STRING = 253;
    public static final int MYSQL_TYPE_STRING = 254;
    public static final int MYSQL_TYPE_GEOMETRY = 255;
    protected static final Logger logger = LoggerFactory.getLogger(LogEvent.class);
    protected final LogHeader header;

    public static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "Start_v3";
            }
            case 3: {
                return "Stop";
            }
            case 2: {
                return "Query";
            }
            case 4: {
                return "Rotate";
            }
            case 5: {
                return "Intvar";
            }
            case 6: {
                return "Load";
            }
            case 12: {
                return "New_load";
            }
            case 7: {
                return "Slave";
            }
            case 8: {
                return "Create_file";
            }
            case 9: {
                return "Append_block";
            }
            case 11: {
                return "Delete_file";
            }
            case 10: {
                return "Exec_load";
            }
            case 13: {
                return "RAND";
            }
            case 16: {
                return "Xid";
            }
            case 14: {
                return "User var";
            }
            case 15: {
                return "Format_desc";
            }
            case 19: {
                return "Table_map";
            }
            case 20: {
                return "Write_rows_event_old";
            }
            case 21: {
                return "Update_rows_event_old";
            }
            case 22: {
                return "Delete_rows_event_old";
            }
            case 23: {
                return "Write_rows_v1";
            }
            case 24: {
                return "Update_rows_v1";
            }
            case 25: {
                return "Delete_rows_v1";
            }
            case 17: {
                return "Begin_load_query";
            }
            case 18: {
                return "Execute_load_query";
            }
            case 26: {
                return "Incident";
            }
            case 27: {
                return "Heartbeat";
            }
            case 28: {
                return "Ignorable";
            }
            case 29: {
                return "Rows_query";
            }
            case 30: {
                return "Write_rows";
            }
            case 31: {
                return "Update_rows";
            }
            case 32: {
                return "Delete_rows";
            }
            case 33: {
                return "Gtid";
            }
            case 34: {
                return "Anonymous_Gtid";
            }
            case 35: {
                return "Previous_gtids";
            }
        }
        return "Unknown";
    }

    protected LogEvent(LogHeader header) {
        this.header = header;
    }

    public final LogHeader getHeader() {
        return this.header;
    }

    public final int getEventLen() {
        return this.header.getEventLen();
    }

    public final long getServerId() {
        return this.header.getServerId();
    }

    public final long getLogPos() {
        return this.header.getLogPos();
    }

    public final long getWhen() {
        return this.header.getWhen();
    }
}

