/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser;

import java.io.IOException;
import java.util.BitSet;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogContext;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.LogPosition;
import net.wicp.tams.common.binlog.parser.event.AppendBlockLogEvent;
import net.wicp.tams.common.binlog.parser.event.BeginLoadQueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.CreateFileLogEvent;
import net.wicp.tams.common.binlog.parser.event.DeleteFileLogEvent;
import net.wicp.tams.common.binlog.parser.event.DeleteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.ExecuteLoadLogEvent;
import net.wicp.tams.common.binlog.parser.event.ExecuteLoadQueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.GtidLogEvent;
import net.wicp.tams.common.binlog.parser.event.HeartbeatLogEvent;
import net.wicp.tams.common.binlog.parser.event.IgnorableLogEvent;
import net.wicp.tams.common.binlog.parser.event.IncidentLogEvent;
import net.wicp.tams.common.binlog.parser.event.IntvarLogEvent;
import net.wicp.tams.common.binlog.parser.event.LoadLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;
import net.wicp.tams.common.binlog.parser.event.PreviousGtidsLogEvent;
import net.wicp.tams.common.binlog.parser.event.QueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.RandLogEvent;
import net.wicp.tams.common.binlog.parser.event.RotateLogEvent;
import net.wicp.tams.common.binlog.parser.event.RowsQueryLogEvent;
import net.wicp.tams.common.binlog.parser.event.StartLogEventV3;
import net.wicp.tams.common.binlog.parser.event.StopLogEvent;
import net.wicp.tams.common.binlog.parser.event.TableMapLogEvent;
import net.wicp.tams.common.binlog.parser.event.UnknownLogEvent;
import net.wicp.tams.common.binlog.parser.event.UpdateRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.UserVarLogEvent;
import net.wicp.tams.common.binlog.parser.event.WriteRowsLogEvent;
import net.wicp.tams.common.binlog.parser.event.XidLogEvent;
import net.wicp.tams.common.binlog.parser.event.mariadb.AnnotateRowsEvent;
import net.wicp.tams.common.binlog.parser.event.mariadb.BinlogCheckPointLogEvent;
import net.wicp.tams.common.binlog.parser.event.mariadb.MariaGtidListLogEvent;
import net.wicp.tams.common.binlog.parser.event.mariadb.MariaGtidLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogDecoder {
    protected static final Logger logger = LoggerFactory.getLogger(LogDecoder.class);
    protected final BitSet handleSet = new BitSet(164);

    public LogDecoder() {
    }

    public LogDecoder(int fromIndex, int toIndex) {
        this.handleSet.set(fromIndex, toIndex);
    }

    public final void handle(int fromIndex, int toIndex) {
        this.handleSet.set(fromIndex, toIndex);
    }

    public final void handle(int flagIndex) {
        this.handleSet.set(flagIndex);
    }

    public LogEvent decode(LogBuffer buffer, LogContext context) throws IOException {
        LogHeader header;
        int len;
        int limit = buffer.limit();
        if (limit >= 19 && limit >= (len = (header = new LogHeader(buffer, context.getFormatDescription())).getEventLen())) {
            LogEvent event;
            if (this.handleSet.get(header.getType())) {
                buffer.limit(len);
                try {
                    event = LogDecoder.decode(buffer, header, context);
                }
                catch (IOException e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Decoding " + LogEvent.getTypeName(header.getType()) + " failed from: " + context.getLogPosition(), (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    buffer.limit(limit);
                }
            } else {
                event = new UnknownLogEvent(header);
            }
            buffer.consume(len);
            return event;
        }
        buffer.rewind();
        return null;
    }

    public static LogEvent decode(LogBuffer buffer, LogHeader header, LogContext context) throws IOException {
        FormatDescriptionLogEvent descriptionEvent = context.getFormatDescription();
        LogPosition logPosition = context.getLogPosition();
        int checksumAlg = 255;
        checksumAlg = header.getType() != 15 ? descriptionEvent.header.getChecksumAlg() : header.getChecksumAlg();
        if (checksumAlg != 0 && checksumAlg != 255) {
            buffer.limit(header.getEventLen() - 4);
        }
        switch (header.getType()) {
            case 2: {
                QueryLogEvent event = new QueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 16: {
                XidLogEvent event = new XidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 19: {
                TableMapLogEvent mapEvent = new TableMapLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                context.putTable(mapEvent);
                return mapEvent;
            }
            case 23: {
                WriteRowsLogEvent event = new WriteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 24: {
                UpdateRowsLogEvent event = new UpdateRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 25: {
                DeleteRowsLogEvent event = new DeleteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 4: {
                RotateLogEvent event = new RotateLogEvent(header, buffer, descriptionEvent);
                logPosition = new LogPosition(event.getFilename(), event.getPosition());
                context.setLogPosition(logPosition);
                return event;
            }
            case 6: 
            case 12: {
                LoadLogEvent event = new LoadLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 7: {
                if (!logger.isWarnEnabled()) break;
                logger.warn("Skipping unsupported SLAVE_EVENT from: " + context.getLogPosition());
                break;
            }
            case 8: {
                CreateFileLogEvent event = new CreateFileLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 9: {
                AppendBlockLogEvent event = new AppendBlockLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 11: {
                DeleteFileLogEvent event = new DeleteFileLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 10: {
                ExecuteLoadLogEvent event = new ExecuteLoadLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 1: {
                StartLogEventV3 event = new StartLogEventV3(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 3: {
                StopLogEvent event = new StopLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 5: {
                IntvarLogEvent event = new IntvarLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 13: {
                RandLogEvent event = new RandLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 14: {
                UserVarLogEvent event = new UserVarLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 15: {
                descriptionEvent = new FormatDescriptionLogEvent(header, buffer, descriptionEvent);
                context.setFormatDescription(descriptionEvent);
                return descriptionEvent;
            }
            case 20: {
                if (!logger.isWarnEnabled()) break;
                logger.warn("Skipping unsupported PRE_GA_WRITE_ROWS_EVENT from: " + context.getLogPosition());
                break;
            }
            case 21: {
                if (!logger.isWarnEnabled()) break;
                logger.warn("Skipping unsupported PRE_GA_UPDATE_ROWS_EVENT from: " + context.getLogPosition());
                break;
            }
            case 22: {
                if (!logger.isWarnEnabled()) break;
                logger.warn("Skipping unsupported PRE_GA_DELETE_ROWS_EVENT from: " + context.getLogPosition());
                break;
            }
            case 17: {
                BeginLoadQueryLogEvent event = new BeginLoadQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 18: {
                ExecuteLoadQueryLogEvent event = new ExecuteLoadQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 26: {
                IncidentLogEvent event = new IncidentLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 27: {
                HeartbeatLogEvent event = new HeartbeatLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 28: {
                IgnorableLogEvent event = new IgnorableLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 29: {
                RowsQueryLogEvent event = new RowsQueryLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 30: {
                WriteRowsLogEvent event = new WriteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 31: {
                UpdateRowsLogEvent event = new UpdateRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 32: {
                DeleteRowsLogEvent event = new DeleteRowsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                event.fillTable(context);
                return event;
            }
            case 33: 
            case 34: {
                GtidLogEvent event = new GtidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 35: {
                PreviousGtidsLogEvent event = new PreviousGtidsLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 160: {
                AnnotateRowsEvent event = new AnnotateRowsEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 161: {
                BinlogCheckPointLogEvent event = new BinlogCheckPointLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 162: {
                MariaGtidLogEvent event = new MariaGtidLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            case 163: {
                MariaGtidListLogEvent event = new MariaGtidListLogEvent(header, buffer, descriptionEvent);
                logPosition.position = header.getLogPos();
                return event;
            }
            default: {
                if ((buffer.getUint16(17) & 0x80) > 0) {
                    IgnorableLogEvent event = new IgnorableLogEvent(header, buffer, descriptionEvent);
                    logPosition.position = header.getLogPos();
                    return event;
                }
                if (!logger.isWarnEnabled()) break;
                logger.warn("Skipping unrecognized binlog event " + LogEvent.getTypeName(header.getType()) + " from: " + context.getLogPosition());
            }
        }
        logPosition.position = header.getLogPos();
        return new UnknownLogEvent(header);
    }
}

