/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import java.util.BitSet;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogContext;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;
import net.wicp.tams.common.binlog.parser.event.RowsLogBuffer;
import net.wicp.tams.common.binlog.parser.event.TableMapLogEvent;

public abstract class RowsLogEvent
extends LogEvent {
    private final long tableId;
    private TableMapLogEvent table;
    protected final int columnLen;
    protected final BitSet columns;
    protected final BitSet changeColumns;
    private final LogBuffer rowsBuf;
    private final int flags;
    public static final int STMT_END_F = 1;
    public static final int NO_FOREIGN_KEY_CHECKS_F = 2;
    public static final int RELAXED_UNIQUE_CHECKS_F = 4;
    public static final int COMPLETE_ROWS_F = 8;
    public static final int RW_MAPID_OFFSET = 0;
    public static final int RW_FLAGS_OFFSET = 6;
    public static final int RW_VHLEN_OFFSET = 8;
    public static final int RW_V_TAG_LEN = 1;
    public static final int RW_V_EXTRAINFO_TAG = 0;

    public RowsLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        int headerLen = 0;
        buffer.position(commonHeaderLen + 0);
        this.tableId = postHeaderLen == 6 ? buffer.getUint32() : buffer.getUlong48();
        this.flags = buffer.getUint16();
        if (postHeaderLen == 10) {
            headerLen = buffer.getUint16();
            int start = buffer.position();
            int end = start + (headerLen -= 2);
            int i = start;
            block3: while (i < end) {
                switch (buffer.getUint8(i++)) {
                    case 0: {
                        buffer.position(i + 0);
                        int checkLen = buffer.getUint8();
                        int val = checkLen - 2;
                        assert (buffer.getUint8() == val);
                        for (int j = 0; j < val; ++j) {
                            assert (buffer.getUint8() == val);
                        }
                        continue block3;
                    }
                    default: {
                        i = end;
                    }
                }
            }
        }
        buffer.position(commonHeaderLen + postHeaderLen + headerLen);
        this.columnLen = (int)buffer.getPackedLong();
        this.columns = buffer.getBitmap(this.columnLen);
        this.changeColumns = header.type == 24 || header.type == 31 ? buffer.getBitmap(this.columnLen) : this.columns;
        int dataSize = buffer.limit() - buffer.position();
        this.rowsBuf = buffer.duplicate(dataSize);
    }

    public final void fillTable(LogContext context) {
        this.table = context.getTable(this.tableId);
        if ((this.flags & 1) != 0) {
            context.clearAllTables();
        }
    }

    public final long getTableId() {
        return this.tableId;
    }

    public final TableMapLogEvent getTable() {
        return this.table;
    }

    public final BitSet getColumns() {
        return this.columns;
    }

    public final BitSet getChangeColumns() {
        return this.changeColumns;
    }

    public final RowsLogBuffer getRowsBuf(String charsetName) {
        return new RowsLogBuffer(this.rowsBuf.duplicate(), this.columnLen, charsetName);
    }

    public final int getFlags(int flags) {
        return this.flags & flags;
    }
}

