/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public class LoadLogEvent
extends LogEvent {
    private String table;
    private String db;
    private String fname;
    private int skipLines;
    private int numFields;
    private String[] fields;
    private String fieldTerm;
    private String lineTerm;
    private String lineStart;
    private String enclosed;
    private String escaped;
    private int optFlags;
    private int emptyFlags;
    private long execTime;
    public static final int L_THREAD_ID_OFFSET = 0;
    public static final int L_EXEC_TIME_OFFSET = 4;
    public static final int L_SKIP_LINES_OFFSET = 8;
    public static final int L_TBL_LEN_OFFSET = 12;
    public static final int L_DB_LEN_OFFSET = 13;
    public static final int L_NUM_FIELDS_OFFSET = 14;
    public static final int L_SQL_EX_OFFSET = 18;
    public static final int L_DATA_OFFSET = 18;
    public static final int DUMPFILE_FLAG = 1;
    public static final int OPT_ENCLOSED_FLAG = 2;
    public static final int REPLACE_FLAG = 4;
    public static final int IGNORE_FLAG = 8;
    public static final int FIELD_TERM_EMPTY = 1;
    public static final int ENCLOSED_EMPTY = 2;
    public static final int LINE_TERM_EMPTY = 4;
    public static final int LINE_START_EMPTY = 8;
    public static final int ESCAPED_EMPTY = 16;

    public LoadLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int loadHeaderLen = 18;
        this.copyLogEvent(buffer, header.type == 6 ? 18 + descriptionEvent.commonHeaderLen : 37, descriptionEvent);
    }

    protected final void copyLogEvent(LogBuffer buffer, int bodyOffset, FormatDescriptionLogEvent descriptionEvent) {
        int found;
        buffer.position(descriptionEvent.commonHeaderLen + 4);
        this.execTime = buffer.getUint32();
        this.skipLines = (int)buffer.getUint32();
        int tableNameLen = buffer.getUint8();
        int dbLen = buffer.getUint8();
        this.numFields = (int)buffer.getUint32();
        buffer.position(bodyOffset);
        if (this.header.type != 6) {
            this.fieldTerm = buffer.getString();
            this.enclosed = buffer.getString();
            this.lineTerm = buffer.getString();
            this.lineStart = buffer.getString();
            this.escaped = buffer.getString();
            this.optFlags = buffer.getInt8();
            this.emptyFlags = 0;
        } else {
            this.fieldTerm = buffer.getFixString(1);
            this.enclosed = buffer.getFixString(1);
            this.lineTerm = buffer.getFixString(1);
            this.lineStart = buffer.getFixString(1);
            this.escaped = buffer.getFixString(1);
            this.optFlags = buffer.getUint8();
            this.emptyFlags = buffer.getUint8();
            if ((this.emptyFlags & 1) != 0) {
                this.fieldTerm = null;
            }
            if ((this.emptyFlags & 2) != 0) {
                this.enclosed = null;
            }
            if ((this.emptyFlags & 4) != 0) {
                this.lineTerm = null;
            }
            if ((this.emptyFlags & 8) != 0) {
                this.lineStart = null;
            }
            if ((this.emptyFlags & 0x10) != 0) {
                this.escaped = null;
            }
        }
        int fieldLenPos = buffer.position();
        buffer.forward(this.numFields);
        this.fields = new String[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            int fieldLen = buffer.getUint8(fieldLenPos + i);
            this.fields[i] = buffer.getFixString(fieldLen + 1);
        }
        this.table = buffer.getFixString(tableNameLen + 1);
        this.db = buffer.getFixString(dbLen + 1);
        int from = buffer.position();
        int end = from + buffer.limit();
        for (found = from; found < end && buffer.getInt8(found) != 0; ++found) {
        }
        this.fname = buffer.getString(found);
        buffer.forward(1);
    }

    public final String getTable() {
        return this.table;
    }

    public final String getDb() {
        return this.db;
    }

    public final String getFname() {
        return this.fname;
    }

    public final int getSkipLines() {
        return this.skipLines;
    }

    public final String[] getFields() {
        return this.fields;
    }

    public final String getFieldTerm() {
        return this.fieldTerm;
    }

    public final String getLineTerm() {
        return this.lineTerm;
    }

    public final String getLineStart() {
        return this.lineStart;
    }

    public final String getEnclosed() {
        return this.enclosed;
    }

    public final String getEscaped() {
        return this.escaped;
    }

    public final int getOptFlags() {
        return this.optFlags;
    }

    public final int getEmptyFlags() {
        return this.emptyFlags;
    }

    public final long getExecTime() {
        return this.execTime;
    }
}

