/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public final class IncidentLogEvent
extends LogEvent {
    public static final int INCIDENT_NONE = 0;
    public static final int INCIDENT_LOST_EVENTS = 1;
    public static final int INCIDENT_COUNT = 2;
    private final int incident;
    private final String message;

    public IncidentLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        buffer.position(commonHeaderLen);
        int incidentNumber = buffer.getUint16();
        if (incidentNumber >= 2 || incidentNumber <= 0) {
            this.incident = 0;
            this.message = null;
            return;
        }
        this.incident = incidentNumber;
        buffer.position(commonHeaderLen + postHeaderLen);
        this.message = buffer.getString();
    }

    public final int getIncident() {
        return this.incident;
    }

    public final String getMessage() {
        return this.message;
    }
}

