/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public class AppendBlockLogEvent
extends LogEvent {
    private final LogBuffer blockBuf;
    private final int blockLen;
    private final long fileId;
    public static final int AB_FILE_ID_OFFSET = 0;

    public AppendBlockLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        int totalHeaderLen = commonHeaderLen + postHeaderLen;
        buffer.position(commonHeaderLen + 0);
        this.fileId = buffer.getUint32();
        buffer.position(postHeaderLen);
        this.blockLen = buffer.limit() - totalHeaderLen;
        this.blockBuf = buffer.duplicate(this.blockLen);
    }

    public final long getFileId() {
        return this.fileId;
    }

    public final LogBuffer getBuffer() {
        return this.blockBuf;
    }

    public final byte[] getData() {
        return this.blockBuf.getData();
    }
}

