/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import net.wicp.tams.common.binlog.parser.LogBuffer;

public abstract class LogFetcher
extends LogBuffer
implements Closeable {
    public static final int DEFAULT_INITIAL_CAPACITY = 8192;
    public static final float DEFAULT_GROWTH_FACTOR = 2.0f;
    public static final int BIN_LOG_HEADER_SIZE = 4;
    protected final float factor;

    public LogFetcher() {
        this(8192, 2.0f);
    }

    public LogFetcher(int initialCapacity) {
        this(initialCapacity, 2.0f);
    }

    public LogFetcher(int initialCapacity, float growthFactor) {
        this.buffer = new byte[initialCapacity];
        this.factor = growthFactor;
    }

    protected final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buffer.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = (int)((float)oldCapacity * this.factor);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        }
    }

    public abstract boolean fetch() throws IOException;

    @Override
    public abstract void close() throws IOException;
}

