/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class AssitWrite {
    private final byte[] buff;
    private int curPos = 0;

    public AssitWrite(int size) {
        this.buff = new byte[size];
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        AssitWrite.reverse(array, 0, array.length);
    }

    public static byte[] toByteArray(int num) {
        byte[] r = new byte[4];
        for (int i = 0; i < 4; ++i) {
            r[i] = (byte)(num >>> 24 - i * 8);
        }
        return r;
    }

    public static byte[] toByteArray(long num) {
        byte[] r = new byte[8];
        for (int i = 0; i < 8; ++i) {
            r[i] = (byte)(num >>> 56 - i * 8);
        }
        return r;
    }

    public static void reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static byte[][] splitBytes(byte[] data, int maxLength) {
        if (data.length <= maxLength) {
            return new byte[][]{data};
        }
        int length = data.length / maxLength + 1;
        byte[][] retary = new byte[length][maxLength];
        for (int l = 0; l < data.length; ++l) {
            int i = l / maxLength;
            int j = l % maxLength;
            retary[i][j] = data[l];
        }
        return retary;
    }

    public void writeByte(byte[] data, int leng, boolean littleEndian) {
        if (littleEndian) {
            AssitWrite.reverse(data);
        }
        int copylen = data.length > leng ? leng : data.length;
        for (int i = 0; i < copylen; ++i) {
            this.buff[this.curPos + i] = data[i];
        }
        this.curPos += leng;
    }

    public void write(byte[] data) {
        this.writeByte(data, data.length, false);
    }

    public void write(int data, int leng) {
        this.writeByte(AssitWrite.toByteArray(data), leng, true);
    }

    public void write(long data, int leng) {
        this.writeByte(AssitWrite.toByteArray(data), leng, true);
    }

    public void write(String data, int leng) {
        try {
            this.writeByte(data.getBytes("UTF-8"), leng, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void write(String data) {
        this.write(data, data.length());
    }

    public void writeEndNull(byte[] data) {
        this.write(data);
        this.write(0, 1);
    }

    public byte[] get() {
        return Arrays.copyOf(this.buff, this.curPos);
    }
}

