/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import java.io.IOException;
import java.nio.charset.Charset;
import net.wicp.tams.common.binlog.parser.CharsetConversion;
import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public class QueryLogEvent
extends LogEvent {
    public static final int MAX_DBS_IN_EVENT_MTS = 16;
    public static final int OVER_MAX_DBS_IN_EVENT_MTS = 254;
    public static final int SYSTEM_CHARSET_MBMAXLEN = 3;
    public static final int NAME_CHAR_LEN = 64;
    public static final int NAME_LEN = 192;
    public static final int MAX_SIZE_LOG_EVENT_STATUS = 3730;
    private String user;
    private String host;
    protected String query;
    protected String catalog;
    protected final String dbname;
    private final long execTime;
    private final int errorCode;
    private final long sessionId;
    private long flags2;
    private long sql_mode;
    private long autoIncrementIncrement = -1L;
    private long autoIncrementOffset = -1L;
    private int clientCharset = -1;
    private int clientCollation = -1;
    private int serverCollation = -1;
    private String charsetName;
    private String timezone;
    public static final int Q_THREAD_ID_OFFSET = 0;
    public static final int Q_EXEC_TIME_OFFSET = 4;
    public static final int Q_DB_LEN_OFFSET = 8;
    public static final int Q_ERR_CODE_OFFSET = 9;
    public static final int Q_STATUS_VARS_LEN_OFFSET = 11;
    public static final int Q_DATA_OFFSET = 13;
    public static final int Q_FLAGS2_CODE = 0;
    public static final int Q_SQL_MODE_CODE = 1;
    public static final int Q_CATALOG_CODE = 2;
    public static final int Q_AUTO_INCREMENT = 3;
    public static final int Q_CHARSET_CODE = 4;
    public static final int Q_TIME_ZONE_CODE = 5;
    public static final int Q_CATALOG_NZ_CODE = 6;
    public static final int Q_LC_TIME_NAMES_CODE = 7;
    public static final int Q_CHARSET_DATABASE_CODE = 8;
    public static final int Q_TABLE_MAP_FOR_UPDATE_CODE = 9;
    public static final int Q_MASTER_DATA_WRITTEN_CODE = 10;
    public static final int Q_INVOKER = 11;
    public static final int Q_UPDATED_DB_NAMES = 12;
    public static final int Q_MICROSECONDS = 13;
    public static final int Q_HRNOW = 128;
    public static final int OPTION_AUTO_IS_NULL = 16384;
    public static final int OPTION_NOT_AUTOCOMMIT = 524288;
    public static final int OPTION_NO_FOREIGN_KEY_CHECKS = 0x4000000;
    public static final int OPTION_RELAXED_UNIQUE_CHECKS = 0x8000000;

    public QueryLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) throws IOException {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        if (buffer.limit() < commonHeaderLen + postHeaderLen) {
            throw new IOException("Query event length is too short.");
        }
        int dataLen = buffer.limit() - (commonHeaderLen + postHeaderLen);
        buffer.position(commonHeaderLen + 0);
        this.sessionId = buffer.getUint32();
        this.execTime = buffer.getUint32();
        int dbLen = buffer.getUint8();
        this.errorCode = buffer.getUint16();
        int statusVarsLen = 0;
        if (postHeaderLen > 11) {
            statusVarsLen = buffer.getUint16();
            if (statusVarsLen > Math.min(dataLen, 3730)) {
                throw new IOException("status_vars_len (" + statusVarsLen + ") > data_len (" + dataLen + ")");
            }
            dataLen -= statusVarsLen;
        }
        int start = commonHeaderLen + postHeaderLen;
        int limit = buffer.limit();
        int end = start + statusVarsLen;
        buffer.position(start).limit(end);
        this.unpackVariables(buffer, end);
        buffer.position(end);
        buffer.limit(limit);
        int queryLen = dataLen - dbLen - 1;
        this.dbname = buffer.getFixString(dbLen + 1);
        if (this.clientCharset >= 0) {
            this.charsetName = CharsetConversion.getJavaCharset(this.clientCharset);
            if (this.charsetName != null && Charset.isSupported(this.charsetName)) {
                this.query = buffer.getFixString(queryLen, this.charsetName);
            } else {
                logger.warn("unsupported character set in query log: \n    ID = " + this.clientCharset + ", Charset = " + CharsetConversion.getCharset(this.clientCharset) + ", Collation = " + CharsetConversion.getCollation(this.clientCharset));
                this.query = buffer.getFixString(queryLen);
            }
        } else {
            this.query = buffer.getFixString(queryLen);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unpackVariables(LogBuffer buffer, int end) throws IOException {
        int code = -1;
        try {
            block19: while (buffer.position() < end) {
                code = buffer.getUint8();
                switch (code) {
                    case 0: {
                        this.flags2 = buffer.getUint32();
                        continue block19;
                    }
                    case 1: {
                        this.sql_mode = buffer.getLong64();
                        continue block19;
                    }
                    case 6: {
                        this.catalog = buffer.getString();
                        continue block19;
                    }
                    case 3: {
                        this.autoIncrementIncrement = buffer.getUint16();
                        this.autoIncrementOffset = buffer.getUint16();
                        continue block19;
                    }
                    case 4: {
                        this.clientCharset = buffer.getUint16();
                        this.clientCollation = buffer.getUint16();
                        this.serverCollation = buffer.getUint16();
                        continue block19;
                    }
                    case 5: {
                        this.timezone = buffer.getString();
                        continue block19;
                    }
                    case 2: {
                        int len = buffer.getUint8();
                        this.catalog = buffer.getFixString(len + 1);
                        continue block19;
                    }
                    case 7: {
                        buffer.forward(2);
                        continue block19;
                    }
                    case 8: {
                        buffer.forward(2);
                        continue block19;
                    }
                    case 9: {
                        buffer.forward(8);
                        continue block19;
                    }
                    case 10: {
                        buffer.forward(4);
                        continue block19;
                    }
                    case 11: {
                        this.user = buffer.getString();
                        this.host = buffer.getString();
                        continue block19;
                    }
                    case 13: {
                        buffer.forward(3);
                        continue block19;
                    }
                    case 12: {
                        int mtsAccessedDbs = buffer.getUint8();
                        if (mtsAccessedDbs > 16) {
                            mtsAccessedDbs = 254;
                            continue block19;
                        }
                        String[] mtsAccessedDbNames = new String[mtsAccessedDbs];
                        for (int i = 0; i < mtsAccessedDbs && buffer.position() < end; ++i) {
                            int length = end - buffer.position();
                            mtsAccessedDbNames[i] = buffer.getFixString(length < 192 ? length : 192);
                        }
                        continue block19;
                    }
                    case 128: {
                        buffer.forward(3);
                        continue block19;
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Query_log_event has unknown status vars (first has code: " + code + "), skipping the rest of them");
            }
            return;
        }
        catch (RuntimeException e) {
            throw new IOException("Read " + QueryLogEvent.findCodeName(code) + " error: " + e.getMessage(), e);
        }
    }

    private static final String findCodeName(int code) {
        switch (code) {
            case 0: {
                return "Q_FLAGS2_CODE";
            }
            case 1: {
                return "Q_SQL_MODE_CODE";
            }
            case 2: {
                return "Q_CATALOG_CODE";
            }
            case 3: {
                return "Q_AUTO_INCREMENT";
            }
            case 4: {
                return "Q_CHARSET_CODE";
            }
            case 5: {
                return "Q_TIME_ZONE_CODE";
            }
            case 6: {
                return "Q_CATALOG_NZ_CODE";
            }
            case 7: {
                return "Q_LC_TIME_NAMES_CODE";
            }
            case 8: {
                return "Q_CHARSET_DATABASE_CODE";
            }
            case 9: {
                return "Q_TABLE_MAP_FOR_UPDATE_CODE";
            }
            case 10: {
                return "Q_MASTER_DATA_WRITTEN_CODE";
            }
            case 12: {
                return "Q_UPDATED_DB_NAMES";
            }
            case 13: {
                return "Q_MICROSECONDS";
            }
        }
        return "CODE#" + code;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getHost() {
        return this.host;
    }

    public final String getQuery() {
        return this.query;
    }

    public final String getCatalog() {
        return this.catalog;
    }

    public final String getDbName() {
        return this.dbname;
    }

    public final long getExecTime() {
        return this.execTime;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public final long getAutoIncrementIncrement() {
        return this.autoIncrementIncrement;
    }

    public final long getAutoIncrementOffset() {
        return this.autoIncrementOffset;
    }

    public final String getCharsetName() {
        return this.charsetName;
    }

    public final String getTimezone() {
        return this.timezone;
    }

    public final int getClientCharset() {
        return this.clientCharset;
    }

    public final int getClientCollation() {
        return this.clientCollation;
    }

    public final int getServerCollation() {
        return this.serverCollation;
    }

    public final long getSqlMode() {
        return this.sql_mode;
    }

    public final long getFlags2() {
        return this.flags2;
    }

    public final boolean isAutoIsNull() {
        return (this.flags2 & 0x4000L) == 16384L;
    }

    public final boolean isForeignKeyChecks() {
        return (this.flags2 & 0x4000000L) != 0x4000000L;
    }

    public final boolean isAutocommit() {
        return (this.flags2 & 0x80000L) != 524288L;
    }

    public final boolean isUniqueChecks() {
        return (this.flags2 & 0x8000000L) != 0x8000000L;
    }
}

