/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.parser.event;

import net.wicp.tams.common.binlog.parser.LogBuffer;
import net.wicp.tams.common.binlog.parser.LogEvent;
import net.wicp.tams.common.binlog.parser.event.FormatDescriptionLogEvent;
import net.wicp.tams.common.binlog.parser.event.LogHeader;

public class GtidLogEvent
extends LogEvent {
    public static final int ENCODED_FLAG_LENGTH = 1;
    public static final int ENCODED_SID_LENGTH = 16;
    private boolean commitFlag;
    private String gtid;
    private String source;

    public GtidLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        buffer.position(commonHeaderLen);
        this.commitFlag = buffer.getUint8() != 0;
        byte[] sid = buffer.getData(16);
        long gno = buffer.getLong64();
        this.source = this.byteArrayToHex(sid, 0, 4) + "-" + this.byteArrayToHex(sid, 4, 2) + "-" + this.byteArrayToHex(sid, 6, 2) + "-" + this.byteArrayToHex(sid, 8, 2) + "-" + this.byteArrayToHex(sid, 10, 6);
        this.gtid = String.format("%s:%d", this.source, gno);
    }

    private String byteArrayToHex(byte[] a, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        for (int idx = offset; idx < offset + len && idx < a.length; ++idx) {
            sb.append(String.format("%02x", a[idx] & 0xFF));
        }
        return sb.toString();
    }

    public boolean isCommitFlag() {
        return this.commitFlag;
    }

    public String getGtid() {
        return this.gtid;
    }

    public String getSource() {
        return this.source;
    }
}

